/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.metrics.Measure;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentWithBinding;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.view.Aggregations;

abstract class AbstractMeasure<B extends AbstractBoundInstrument>
extends AbstractInstrumentWithBinding<B> {
    private final boolean absolute;
    private final InstrumentValueType instrumentValueType;

    AbstractMeasure(InstrumentDescriptor descriptor, InstrumentValueType instrumentValueType, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, boolean absolute) {
        super(descriptor, meterProviderSharedState, meterSharedState, new ActiveBatcher(AbstractMeasure.getDefaultBatcher(descriptor, AbstractMeasure.getInstrumentType(absolute), instrumentValueType, meterProviderSharedState, meterSharedState, Aggregations.minMaxSumCount())));
        this.absolute = absolute;
        this.instrumentValueType = instrumentValueType;
    }

    final boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractMeasure)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractMeasure that = (AbstractMeasure)o;
        return this.absolute == that.absolute && this.instrumentValueType == that.instrumentValueType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.absolute ? 1 : 0);
        result = 31 * result + this.instrumentValueType.hashCode();
        return result;
    }

    private static InstrumentType getInstrumentType(boolean absolute) {
        return absolute ? InstrumentType.MEASURE_ABSOLUTE : InstrumentType.MEASURE_NON_ABSOLUTE;
    }

    static abstract class Builder<B extends Builder<B>>
    extends AbstractInstrument.Builder<B>
    implements Measure.Builder {
        private boolean absolute = true;

        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, meterProviderSharedState, meterSharedState);
        }

        public final B setAbsolute(boolean absolute) {
            this.absolute = absolute;
            return (B)((Builder)this.getThis());
        }

        final boolean isAbsolute() {
            return this.absolute;
        }
    }
}

