/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.export;

import io.opentelemetry.internal.Utils;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanData;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SimpleSpansProcessor
implements SpanProcessor {
    private static final Logger logger = Logger.getLogger(SimpleSpansProcessor.class.getName());
    private final SpanExporter spanExporter;
    private final boolean sampled;

    private SimpleSpansProcessor(SpanExporter spanExporter, boolean sampled) {
        this.spanExporter = (SpanExporter)Utils.checkNotNull((Object)spanExporter, (Object)"spanExporter");
        this.sampled = sampled;
    }

    @Override
    public void onStart(ReadableSpan span) {
    }

    @Override
    public void onEnd(ReadableSpan span) {
        if (this.sampled && !span.getSpanContext().getTraceFlags().isSampled()) {
            return;
        }
        try {
            List<SpanData> spans = Collections.singletonList(span.toSpanData());
            this.spanExporter.export(spans);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception thrown by the export.", e);
        }
    }

    @Override
    public void shutdown() {
        this.spanExporter.shutdown();
    }

    public static Builder newBuilder(SpanExporter spanExporter) {
        return new Builder(spanExporter);
    }

    public static final class Builder {
        private final SpanExporter spanExporter;
        private boolean sampled = true;

        private Builder(SpanExporter spanExporter) {
            this.spanExporter = (SpanExporter)Utils.checkNotNull((Object)spanExporter, (Object)"spanExporter");
        }

        public Builder reportOnlySampled(boolean sampled) {
            this.sampled = sampled;
            return this;
        }

        public SimpleSpansProcessor build() {
            return new SimpleSpansProcessor(this.spanExporter, this.sampled);
        }
    }
}

