/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.AutoValue_SpanData;
import io.opentelemetry.sdk.trace.AutoValue_SpanData_Link;
import io.opentelemetry.sdk.trace.AutoValue_SpanData_TimedEvent;
import io.opentelemetry.sdk.trace.InstrumentationLibraryInfo;
import io.opentelemetry.trace.AttributeValue;
import io.opentelemetry.trace.Event;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.Status;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.Tracestate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class SpanData {
    public abstract TraceId getTraceId();

    public abstract SpanId getSpanId();

    public abstract TraceFlags getTraceFlags();

    public abstract Tracestate getTracestate();

    public abstract SpanId getParentSpanId();

    public abstract Resource getResource();

    public abstract InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    public abstract String getName();

    public abstract Span.Kind getKind();

    public abstract long getStartEpochNanos();

    public abstract Map<String, AttributeValue> getAttributes();

    public abstract List<TimedEvent> getTimedEvents();

    public abstract List<io.opentelemetry.trace.Link> getLinks();

    public abstract Status getStatus();

    public abstract long getEndEpochNanos();

    public abstract boolean getHasRemoteParent();

    public static Builder newBuilder() {
        return new AutoValue_SpanData.Builder().setParentSpanId(SpanId.getInvalid()).setInstrumentationLibraryInfo(InstrumentationLibraryInfo.EMPTY).setLinks(Collections.emptyList()).setAttributes(Collections.emptyMap()).setTimedEvents(Collections.emptyList()).setResource(Resource.getEmpty()).setTracestate(Tracestate.getDefault()).setTraceFlags(TraceFlags.getDefault()).setHasRemoteParent(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract SpanData autoBuild();

        abstract Map<String, AttributeValue> getAttributes();

        abstract List<TimedEvent> getTimedEvents();

        abstract List<io.opentelemetry.trace.Link> getLinks();

        public SpanData build() {
            this.setAttributes(Collections.unmodifiableMap(new HashMap<String, AttributeValue>(this.getAttributes())));
            this.setTimedEvents(Collections.unmodifiableList(new ArrayList<TimedEvent>(this.getTimedEvents())));
            this.setLinks(Collections.unmodifiableList(new ArrayList<io.opentelemetry.trace.Link>(this.getLinks())));
            return this.autoBuild();
        }

        public abstract Builder setTraceId(TraceId var1);

        public abstract Builder setSpanId(SpanId var1);

        public abstract Builder setTraceFlags(TraceFlags var1);

        public abstract Builder setTracestate(Tracestate var1);

        public abstract Builder setParentSpanId(SpanId var1);

        public abstract Builder setResource(Resource var1);

        public abstract Builder setInstrumentationLibraryInfo(InstrumentationLibraryInfo var1);

        public abstract Builder setName(String var1);

        public abstract Builder setStartEpochNanos(long var1);

        public abstract Builder setEndEpochNanos(long var1);

        public abstract Builder setAttributes(Map<String, AttributeValue> var1);

        public abstract Builder setTimedEvents(List<TimedEvent> var1);

        public abstract Builder setStatus(Status var1);

        public abstract Builder setKind(Span.Kind var1);

        public abstract Builder setLinks(List<io.opentelemetry.trace.Link> var1);

        public abstract Builder setHasRemoteParent(boolean var1);
    }

    @Immutable
    @AutoValue
    public static abstract class TimedEvent
    implements Event {
        public static TimedEvent create(long epochNanos, String name, Map<String, AttributeValue> attributes) {
            return new AutoValue_SpanData_TimedEvent(epochNanos, name, attributes);
        }

        public abstract long getEpochNanos();

        public abstract String getName();

        public abstract Map<String, AttributeValue> getAttributes();

        TimedEvent() {
        }
    }

    @Immutable
    @AutoValue
    public static abstract class Link
    implements io.opentelemetry.trace.Link {
        public static Link create(SpanContext spanContext) {
            return new AutoValue_SpanData_Link(spanContext, Collections.emptyMap());
        }

        public static Link create(SpanContext spanContext, Map<String, AttributeValue> attributes) {
            return new AutoValue_SpanData_Link(spanContext, Collections.unmodifiableMap(new LinkedHashMap<String, AttributeValue>(attributes)));
        }
    }
}

