/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.internal.Utils;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.MonotonicClock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdsGenerator;
import io.opentelemetry.sdk.trace.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.trace.RecordEventsReadableSpan;
import io.opentelemetry.sdk.trace.Sampler;
import io.opentelemetry.sdk.trace.SpanData;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.trace.AttributeValue;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Link;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.Tracestate;
import io.opentelemetry.trace.unsafe.ContextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class SpanBuilderSdk
implements Span.Builder {
    private static final TraceFlags TRACE_OPTIONS_SAMPLED = TraceFlags.builder().setIsSampled(true).build();
    private static final TraceFlags TRACE_OPTIONS_NOT_SAMPLED = TraceFlags.builder().setIsSampled(false).build();
    private final String spanName;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;
    private final SpanProcessor spanProcessor;
    private final TraceConfig traceConfig;
    private final Resource resource;
    private final IdsGenerator idsGenerator;
    private final Clock clock;
    @Nullable
    private Span parent;
    @Nullable
    private SpanContext remoteParent;
    private Span.Kind spanKind = Span.Kind.INTERNAL;
    private List<Link> links;
    private ParentType parentType = ParentType.CURRENT_SPAN;
    private long startEpochNanos = 0L;

    SpanBuilderSdk(String spanName, InstrumentationLibraryInfo instrumentationLibraryInfo, SpanProcessor spanProcessor, TraceConfig traceConfig, Resource resource, IdsGenerator idsGenerator, Clock clock) {
        this.spanName = spanName;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
        this.spanProcessor = spanProcessor;
        this.traceConfig = traceConfig;
        this.resource = resource;
        this.links = Collections.emptyList();
        this.idsGenerator = idsGenerator;
        this.clock = clock;
    }

    public Span.Builder setParent(Span parent) {
        this.parent = (Span)Utils.checkNotNull((Object)parent, (Object)"parent");
        this.remoteParent = null;
        this.parentType = ParentType.EXPLICIT_PARENT;
        return this;
    }

    public Span.Builder setParent(SpanContext remoteParent) {
        this.remoteParent = (SpanContext)Utils.checkNotNull((Object)remoteParent, (Object)"remoteParent");
        this.parent = null;
        this.parentType = ParentType.EXPLICIT_REMOTE_PARENT;
        return this;
    }

    public Span.Builder setNoParent() {
        this.parentType = ParentType.NO_PARENT;
        this.parent = null;
        this.remoteParent = null;
        return this;
    }

    public Span.Builder setSpanKind(Span.Kind spanKind) {
        this.spanKind = (Span.Kind)Utils.checkNotNull((Object)spanKind, (Object)"spanKind");
        return this;
    }

    public Span.Builder addLink(SpanContext spanContext) {
        this.addLink(SpanData.Link.create(spanContext));
        return this;
    }

    public Span.Builder addLink(SpanContext spanContext, Map<String, AttributeValue> attributes) {
        this.addLink(SpanData.Link.create(spanContext, attributes));
        return this;
    }

    public Span.Builder addLink(Link link) {
        Utils.checkNotNull((Object)link, (Object)"link");
        if (this.links.isEmpty()) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(link);
        return this;
    }

    public Span.Builder setStartTimestamp(long startTimestamp) {
        Utils.checkArgument((startTimestamp >= 0L ? 1 : 0) != 0, (Object)"Negative startTimestamp");
        this.startEpochNanos = startTimestamp;
        return this;
    }

    public Span startSpan() {
        TraceId traceId;
        SpanContext parentContext = SpanBuilderSdk.parent(this.parentType, this.parent, this.remoteParent);
        SpanId spanId = this.idsGenerator.generateSpanId();
        Tracestate tracestate = Tracestate.getDefault();
        if (parentContext == null || !parentContext.isValid()) {
            traceId = this.idsGenerator.generateTraceId();
            parentContext = null;
        } else {
            traceId = parentContext.getTraceId();
            tracestate = parentContext.getTracestate();
        }
        Sampler.Decision samplingDecision = this.traceConfig.getSampler().shouldSample(parentContext, traceId, spanId, this.spanName, this.links);
        SpanContext spanContext = SpanContext.create((TraceId)traceId, (SpanId)spanId, (TraceFlags)(samplingDecision.isSampled() ? TRACE_OPTIONS_SAMPLED : TRACE_OPTIONS_NOT_SAMPLED), (Tracestate)tracestate);
        if (!samplingDecision.isSampled()) {
            return DefaultSpan.create((SpanContext)spanContext);
        }
        return RecordEventsReadableSpan.startSpan(spanContext, this.spanName, this.instrumentationLibraryInfo, this.spanKind, parentContext != null ? parentContext.getSpanId() : null, parentContext != null ? parentContext.isRemote() : false, this.traceConfig, this.spanProcessor, SpanBuilderSdk.getClock(SpanBuilderSdk.parentSpan(this.parentType, this.parent), this.clock), this.resource, samplingDecision.attributes(), this.truncatedLinks(), this.links.size(), this.startEpochNanos);
    }

    private List<Link> truncatedLinks() {
        if (this.links.size() <= this.traceConfig.getMaxNumberOfLinks()) {
            return this.links;
        }
        return this.links.subList(this.links.size() - this.traceConfig.getMaxNumberOfLinks(), this.links.size());
    }

    private static Clock getClock(Span parent, Clock clock) {
        if (parent instanceof RecordEventsReadableSpan) {
            RecordEventsReadableSpan parentRecordEventsSpan = (RecordEventsReadableSpan)parent;
            parentRecordEventsSpan.addChild();
            return parentRecordEventsSpan.getClock();
        }
        return MonotonicClock.create(clock);
    }

    @Nullable
    private static SpanContext parent(ParentType parentType, Span explicitParent, SpanContext remoteParent) {
        Span currentSpan = ContextUtils.getValue();
        switch (parentType) {
            case NO_PARENT: {
                return null;
            }
            case CURRENT_SPAN: {
                return currentSpan != null ? currentSpan.getContext() : null;
            }
            case EXPLICIT_PARENT: {
                return explicitParent.getContext();
            }
            case EXPLICIT_REMOTE_PARENT: {
                return remoteParent;
            }
        }
        throw new IllegalStateException("Unknown parent type");
    }

    @Nullable
    private static Span parentSpan(ParentType parentType, Span explicitParent) {
        switch (parentType) {
            case CURRENT_SPAN: {
                return ContextUtils.getValue();
            }
            case EXPLICIT_PARENT: {
                return explicitParent;
            }
        }
        return null;
    }

    private static enum ParentType {
        CURRENT_SPAN,
        EXPLICIT_PARENT,
        EXPLICIT_REMOTE_PARENT,
        NO_PARENT;

    }
}

