/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.internal.Utils;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class MultiSpanProcessor
implements SpanProcessor {
    private final List<SpanProcessor> spanProcessors;

    public static SpanProcessor create(List<SpanProcessor> spanProcessorList) {
        return new MultiSpanProcessor(Collections.unmodifiableList(new ArrayList((Collection)Utils.checkNotNull(spanProcessorList, (Object)"spanProcessorList"))));
    }

    @Override
    public void onStart(ReadableSpan readableSpan) {
        for (SpanProcessor spanProcessor : this.spanProcessors) {
            spanProcessor.onStart(readableSpan);
        }
    }

    @Override
    public void onEnd(ReadableSpan readableSpan) {
        for (SpanProcessor spanProcessor : this.spanProcessors) {
            spanProcessor.onEnd(readableSpan);
        }
    }

    @Override
    public void shutdown() {
        for (SpanProcessor spanProcessor : this.spanProcessors) {
            spanProcessor.shutdown();
        }
    }

    private MultiSpanProcessor(List<SpanProcessor> spanProcessors) {
        this.spanProcessors = spanProcessors;
    }
}

