/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.resources;

import com.google.auto.value.AutoValue;
import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.sdk.resources.AutoValue_Resource;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class Resource {
    private static final int MAX_LENGTH = 255;
    private static final String ERROR_MESSAGE_INVALID_CHARS = " should be a ASCII string with a length greater than 0 and not exceed 255 characters.";
    private static final String ERROR_MESSAGE_INVALID_VALUE = " should be a ASCII string with a length not exceed 255 characters.";
    private static final Resource EMPTY = Resource.create(Collections.emptyMap());

    Resource() {
    }

    public static Resource getEmpty() {
        return EMPTY;
    }

    public abstract Map<String, String> getLabels();

    public static Resource create(Map<String, String> labels) {
        Resource.checkLabels((Map)Utils.checkNotNull(labels, (Object)"labels"));
        return new AutoValue_Resource(Collections.unmodifiableMap(new LinkedHashMap<String, String>(labels)));
    }

    public Resource merge(@Nullable Resource other) {
        if (other == null) {
            return this;
        }
        LinkedHashMap<String, String> mergedLabelMap = new LinkedHashMap<String, String>(other.getLabels());
        for (Map.Entry<String, String> entry : this.getLabels().entrySet()) {
            mergedLabelMap.put(entry.getKey(), entry.getValue());
        }
        return new AutoValue_Resource(Collections.unmodifiableMap(mergedLabelMap));
    }

    private static void checkLabels(Map<String, String> labels) {
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            Utils.checkArgument((boolean)Resource.isValidAndNotEmpty(entry.getKey()), (Object)"Label key should be a ASCII string with a length greater than 0 and not exceed 255 characters.");
            Utils.checkArgument((boolean)Resource.isValid(entry.getValue()), (Object)"Label value should be a ASCII string with a length not exceed 255 characters.");
        }
    }

    private static boolean isValid(String name) {
        return name.length() <= 255 && StringUtils.isPrintableString((String)name);
    }

    private static boolean isValidAndNotEmpty(String name) {
        return !name.isEmpty() && Resource.isValid(name);
    }
}

