/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.stats;

import com.google.auto.value.AutoValue;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.sdk.metrics.stats.AutoValue_Aggregation_Count;
import io.opentelemetry.sdk.metrics.stats.AutoValue_Aggregation_Distribution;
import io.opentelemetry.sdk.metrics.stats.AutoValue_Aggregation_LastValue;
import io.opentelemetry.sdk.metrics.stats.AutoValue_Aggregation_Sum;
import io.opentelemetry.sdk.metrics.stats.BucketBoundaries;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Aggregation {
    private Aggregation() {
    }

    public BucketBoundaries getBucketBoundaries() {
        throw new UnsupportedOperationException("Only Distribution Aggregation implements this method.");
    }

    public abstract Type getType();

    public static enum Type {
        SUM,
        COUNT,
        DISTRIBUTION,
        LASTVALUE;

    }

    @Immutable
    @AutoValue
    public static abstract class LastValue
    extends Aggregation {
        private static final LastValue INSTANCE = new AutoValue_Aggregation_LastValue();

        LastValue() {
        }

        public static LastValue create() {
            return INSTANCE;
        }

        @Override
        public final Type getType() {
            return Type.LASTVALUE;
        }
    }

    @Immutable
    @AutoValue
    public static abstract class Distribution
    extends Aggregation {
        Distribution() {
        }

        public static Distribution create(BucketBoundaries bucketBoundaries) {
            Utils.checkNotNull((Object)bucketBoundaries, (Object)"bucketBoundaries");
            return new AutoValue_Aggregation_Distribution(bucketBoundaries);
        }

        @Override
        public abstract BucketBoundaries getBucketBoundaries();

        @Override
        public final Type getType() {
            return Type.DISTRIBUTION;
        }
    }

    @Immutable
    @AutoValue
    public static abstract class Count
    extends Aggregation {
        private static final Count INSTANCE = new AutoValue_Aggregation_Count();

        Count() {
        }

        public static Count create() {
            return INSTANCE;
        }

        @Override
        public final Type getType() {
            return Type.COUNT;
        }
    }

    @Immutable
    @AutoValue
    public static abstract class Sum
    extends Aggregation {
        private static final Sum INSTANCE = new AutoValue_Aggregation_Sum();

        Sum() {
        }

        public static Sum create() {
            return INSTANCE;
        }

        @Override
        public final Type getType() {
            return Type.SUM;
        }
    }
}

