/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.distributedcontext;

import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.distributedcontext.DistributedContext;
import io.opentelemetry.distributedcontext.Entry;
import io.opentelemetry.distributedcontext.EntryKey;
import io.opentelemetry.distributedcontext.EntryMetadata;
import io.opentelemetry.distributedcontext.EntryValue;
import io.opentelemetry.internal.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
class DistributedContextSdk
implements DistributedContext {
    private final Map<EntryKey, Entry> entries;
    @Nullable
    private final DistributedContext parent;

    private DistributedContextSdk(Map<? extends EntryKey, ? extends Entry> entries, DistributedContext parent) {
        this.entries = Collections.unmodifiableMap(new HashMap((Map)Utils.checkNotNull(entries, (Object)"entries")));
        this.parent = parent;
    }

    public Collection<Entry> getEntries() {
        HashMap<EntryKey, Entry> combined = new HashMap<EntryKey, Entry>(this.entries);
        if (this.parent != null) {
            for (Entry entry : this.parent.getEntries()) {
                if (combined.containsKey(entry.getKey())) continue;
                combined.put(entry.getKey(), entry);
            }
        }
        Iterator it = combined.values().iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        return Collections.unmodifiableCollection(combined.values());
    }

    @Nullable
    public EntryValue getEntryValue(EntryKey entryKey) {
        Entry entry = this.entries.get(entryKey);
        if (entry != null) {
            return entry.getValue();
        }
        return this.parent == null ? null : this.parent.getEntryValue(entryKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof DistributedContextSdk)) {
            return false;
        }
        DistributedContextSdk distContextSdk = (DistributedContextSdk)o;
        if (!this.entries.equals(distContextSdk.entries)) {
            return false;
        }
        return this.parent != null ? this.parent.equals(distContextSdk.parent) : distContextSdk.parent == null;
    }

    public int hashCode() {
        int result = this.entries.hashCode();
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        return result;
    }

    static class Builder
    implements DistributedContext.Builder {
        @Nullable
        private DistributedContext parent;
        private boolean noImplicitParent;
        private final Map<EntryKey, Entry> entries = new HashMap<EntryKey, Entry>();

        Builder() {
        }

        public DistributedContext.Builder setParent(DistributedContext parent) {
            this.parent = (DistributedContext)Utils.checkNotNull((Object)parent, (Object)"parent");
            return this;
        }

        public DistributedContext.Builder setNoParent() {
            this.parent = null;
            this.noImplicitParent = true;
            return this;
        }

        public DistributedContext.Builder put(EntryKey key, EntryValue value, EntryMetadata entryMetadata) {
            this.entries.put((EntryKey)Utils.checkNotNull((Object)key, (Object)"key"), Entry.create((EntryKey)key, (EntryValue)((EntryValue)Utils.checkNotNull((Object)value, (Object)"value")), (EntryMetadata)((EntryMetadata)Utils.checkNotNull((Object)entryMetadata, (Object)"entryMetadata"))));
            return this;
        }

        public DistributedContext.Builder remove(EntryKey key) {
            this.entries.remove(Utils.checkNotNull((Object)key, (Object)"key"));
            if (this.parent != null && this.parent.getEntryValue(key) != null) {
                this.entries.put(key, null);
            }
            return this;
        }

        public DistributedContextSdk build() {
            if (this.parent == null && !this.noImplicitParent) {
                this.parent = OpenTelemetry.getDistributedContextManager().getCurrentContext();
            }
            return new DistributedContextSdk(this.entries, this.parent);
        }
    }
}

