/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.trace.SdkTracerManagement;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetrySdk
implements OpenTelemetry {
    private final ObfuscatedTracerProvider tracerProvider;
    private volatile ContextPropagators propagators;

    OpenTelemetrySdk(ObfuscatedTracerProvider tracerProvider, ContextPropagators propagators) {
        this.tracerProvider = tracerProvider;
        this.propagators = propagators;
    }

    public static OpenTelemetrySdkBuilder builder() {
        return new OpenTelemetrySdkBuilder();
    }

    public static OpenTelemetrySdk get() {
        return (OpenTelemetrySdk)GlobalOpenTelemetry.get();
    }

    public static SdkTracerManagement getGlobalTracerManagement() {
        TracerProvider tracerProvider = GlobalOpenTelemetry.get().getTracerProvider();
        if (!(tracerProvider instanceof ObfuscatedTracerProvider)) {
            throw new IllegalStateException("Trying to access global SdkTracerManagement but global TracerProvider is not an instance created by this SDK.");
        }
        return ((ObfuscatedTracerProvider)tracerProvider).unobfuscate();
    }

    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    public ContextPropagators getPropagators() {
        return this.propagators;
    }

    public SdkTracerManagement getTracerManagement() {
        return this.tracerProvider.unobfuscate();
    }

    @ThreadSafe
    static class ObfuscatedTracerProvider
    implements TracerProvider {
        private final SdkTracerProvider delegate;

        ObfuscatedTracerProvider(SdkTracerProvider delegate) {
            this.delegate = delegate;
        }

        public Tracer get(String instrumentationName) {
            return this.delegate.get(instrumentationName);
        }

        public Tracer get(String instrumentationName, String instrumentationVersion) {
            return this.delegate.get(instrumentationName, instrumentationVersion);
        }

        public SdkTracerProvider unobfuscate() {
            return this.delegate;
        }
    }
}

