/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.junit5;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.testing.assertj.TracesAssert;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class OpenTelemetryExtension
implements BeforeEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private final OpenTelemetrySdk openTelemetry;
    private final InMemorySpanExporter spanExporter;

    public static OpenTelemetryExtension create() {
        InMemorySpanExporter spanExporter = InMemorySpanExporter.create();
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)spanExporter)).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(tracerProvider).build();
        return new OpenTelemetryExtension(openTelemetry, spanExporter);
    }

    private OpenTelemetryExtension(OpenTelemetrySdk openTelemetry, InMemorySpanExporter spanExporter) {
        this.openTelemetry = openTelemetry;
        this.spanExporter = spanExporter;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public List<SpanData> getSpans() {
        return this.spanExporter.getFinishedSpanItems();
    }

    public TracesAssert assertTraces() {
        Map traces = this.getSpans().stream().collect(Collectors.groupingBy(SpanData::getTraceId, LinkedHashMap::new, Collectors.toList()));
        for (List trace : traces.values()) {
            trace.sort(Comparator.comparing(SpanData::getStartEpochNanos));
        }
        return TracesAssert.assertThat(traces.values());
    }

    public void clearSpans() {
        this.spanExporter.reset();
    }

    public void beforeEach(ExtensionContext context) {
        this.clearSpans();
    }

    public void beforeAll(ExtensionContext context) {
        GlobalOpenTelemetry.set((OpenTelemetry)this.openTelemetry);
    }

    public void afterAll(ExtensionContext context) {
        GlobalOpenTelemetry.resetForTest();
    }
}

