/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.junit4;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerManagement;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.List;
import org.junit.rules.ExternalResource;

public final class OpenTelemetryRule
extends ExternalResource {
    private final OpenTelemetrySdk openTelemetry;
    private final InMemorySpanExporter spanExporter;

    public static OpenTelemetryRule create() {
        InMemorySpanExporter spanExporter = InMemorySpanExporter.create();
        SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)spanExporter)).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider(tracerProvider).build();
        return new OpenTelemetryRule(openTelemetry, spanExporter);
    }

    private OpenTelemetryRule(OpenTelemetrySdk openTelemetry, InMemorySpanExporter spanExporter) {
        this.openTelemetry = openTelemetry;
        this.spanExporter = spanExporter;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    @Deprecated
    public SdkTracerManagement getTracerManagement() {
        return this.openTelemetry.getSdkTracerProvider();
    }

    public List<SpanData> getSpans() {
        return this.spanExporter.getFinishedSpanItems();
    }

    public void clearSpans() {
        this.spanExporter.reset();
    }

    protected void before() {
        GlobalOpenTelemetry.set((OpenTelemetry)this.openTelemetry);
        this.clearSpans();
    }

    protected void after() {
        GlobalOpenTelemetry.resetForTest();
    }
}

