/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.exporter;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public final class InMemoryMetricExporter
implements MetricExporter {
    private final Queue<MetricData> finishedMetricItems = new LinkedBlockingQueue<MetricData>();
    private boolean isStopped = false;

    private InMemoryMetricExporter() {
    }

    public static InMemoryMetricExporter create() {
        return new InMemoryMetricExporter();
    }

    public List<MetricData> getFinishedMetricItems() {
        return Collections.unmodifiableList(new ArrayList<MetricData>(this.finishedMetricItems));
    }

    public void reset() {
        this.finishedMetricItems.clear();
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        if (this.isStopped) {
            return CompletableResultCode.ofFailure();
        }
        this.finishedMetricItems.addAll(metrics);
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.isStopped = true;
        this.finishedMetricItems.clear();
        return CompletableResultCode.ofSuccess();
    }
}

