/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;

public class SpanDataAssert
extends AbstractAssert<SpanDataAssert, SpanData> {
    SpanDataAssert(SpanData actual) {
        super((Object)actual, SpanDataAssert.class);
    }

    public SpanDataAssert hasTraceId(String traceId) {
        this.isNotNull();
        if (!((SpanData)this.actual).getTraceId().equals(traceId)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getTraceId(), traceId, "Expected span [%s] to have trace ID <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), traceId, ((SpanData)this.actual).getTraceId()});
        }
        return this;
    }

    public SpanDataAssert hasSpanId(String spanId) {
        this.isNotNull();
        if (!((SpanData)this.actual).getSpanId().equals(spanId)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getSpanId(), spanId, "Expected span [%s] to have span ID <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), spanId, ((SpanData)this.actual).getSpanId()});
        }
        return this;
    }

    public SpanDataAssert isSampled() {
        this.isNotNull();
        if (!((SpanData)this.actual).isSampled()) {
            this.failWithMessage("Expected span [%s] to be sampled but was not.", new Object[]{((SpanData)this.actual).getName()});
        }
        return this;
    }

    public SpanDataAssert isNotSampled() {
        this.isNotNull();
        if (((SpanData)this.actual).isSampled()) {
            this.failWithMessage("Expected span [%s] to not be sampled but it was.", new Object[]{((SpanData)this.actual).getName()});
        }
        return this;
    }

    public SpanDataAssert hasTraceState(TraceState traceState) {
        this.isNotNull();
        if (!((SpanData)this.actual).getTraceState().equals(traceState)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getTraceState(), traceState, "Expected span [%s] to have trace state <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), traceState, ((SpanData)this.actual).getTraceState()});
        }
        return this;
    }

    public SpanDataAssert hasParentSpanId(String parentSpanId) {
        this.isNotNull();
        String actualParentSpanId = ((SpanData)this.actual).getParentSpanId();
        if (!actualParentSpanId.equals(parentSpanId)) {
            this.failWithActualExpectedAndMessage(actualParentSpanId, parentSpanId, "Expected span [%s] to have parent span ID <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), parentSpanId, actualParentSpanId});
        }
        return this;
    }

    public SpanDataAssert hasResource(Resource resource) {
        this.isNotNull();
        if (!((SpanData)this.actual).getResource().equals(resource)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getResource(), resource, "Expected span [%s] to have resource <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), resource, ((SpanData)this.actual).getResource()});
        }
        return this;
    }

    public SpanDataAssert hasInstrumentationLibraryInfo(InstrumentationLibraryInfo instrumentationLibraryInfo) {
        this.isNotNull();
        if (!((SpanData)this.actual).getInstrumentationLibraryInfo().equals(instrumentationLibraryInfo)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getInstrumentationLibraryInfo(), instrumentationLibraryInfo, "Expected span [%s] to have instrumentation library info <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), instrumentationLibraryInfo, ((SpanData)this.actual).getInstrumentationLibraryInfo()});
        }
        return this;
    }

    public SpanDataAssert hasName(String name) {
        this.isNotNull();
        if (!((SpanData)this.actual).getName().equals(name)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getName(), name, "Expected span to have name <%s> but was <%s>", new Object[]{name, ((SpanData)this.actual).getName()});
        }
        return this;
    }

    public SpanDataAssert hasKind(Span.Kind kind) {
        this.isNotNull();
        if (!((SpanData)this.actual).getKind().equals((Object)kind)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getKind(), kind, "Expected span [%s] to have kind <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), kind, ((SpanData)this.actual).getKind()});
        }
        return this;
    }

    public SpanDataAssert startsAt(long startEpochNanos) {
        this.isNotNull();
        if (((SpanData)this.actual).getStartEpochNanos() != startEpochNanos) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getStartEpochNanos(), startEpochNanos, "Expected span [%s] to have start epoch <%s> nanos but was <%s>", new Object[]{((SpanData)this.actual).getName(), startEpochNanos, ((SpanData)this.actual).getStartEpochNanos()});
        }
        return this;
    }

    public SpanDataAssert startsAt(long startEpoch, TimeUnit unit) {
        return this.startsAt(unit.toNanos(startEpoch));
    }

    public SpanDataAssert startsAt(Instant timestamp) {
        return this.startsAt(SpanDataAssert.toNanos(timestamp));
    }

    public SpanDataAssert hasAttributes(Attributes attributes) {
        this.isNotNull();
        if (!((SpanData)this.actual).getAttributes().equals(attributes)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getAttributes(), attributes, "Expected span [%s] to have attributes <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), attributes, ((SpanData)this.actual).getAttributes()});
        }
        return this;
    }

    public SpanDataAssert hasAttributesSatisfying(Consumer<Attributes> attributes) {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)((SpanData)this.actual).getAttributes()).as("attributes", new Object[0])).satisfies(attributes);
        return this;
    }

    public SpanDataAssert hasEvents(Iterable<SpanData.Event> events) {
        this.isNotNull();
        ((ListAssert)Assertions.assertThat((List)((SpanData)this.actual).getEvents()).withFailMessage("Expected span [%s] to have events <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), events, ((SpanData)this.actual).getEvents()})).containsExactlyInAnyOrderElementsOf(events);
        return this;
    }

    public SpanDataAssert hasEvents(SpanData.Event ... events) {
        return this.hasEvents(Arrays.asList(events));
    }

    public SpanDataAssert hasEventsSatisfying(Consumer<List<? extends SpanData.Event>> condition) {
        this.isNotNull();
        Assertions.assertThat((List)((SpanData)this.actual).getEvents()).satisfies(condition);
        return this;
    }

    public SpanDataAssert hasLinks(Iterable<SpanData.Link> links) {
        this.isNotNull();
        ((ListAssert)Assertions.assertThat((List)((SpanData)this.actual).getLinks()).withFailMessage("Expected span [%s] to have links <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), links, ((SpanData)this.actual).getLinks()})).containsExactlyInAnyOrderElementsOf(links);
        return this;
    }

    public SpanDataAssert hasLinks(SpanData.Link ... links) {
        return this.hasLinks(Arrays.asList(links));
    }

    public SpanDataAssert hasLinksSatisfying(Consumer<List<? extends SpanData.Link>> condition) {
        this.isNotNull();
        Assertions.assertThat((List)((SpanData)this.actual).getLinks()).satisfies(condition);
        return this;
    }

    public SpanDataAssert hasStatus(SpanData.Status status) {
        this.isNotNull();
        if (!((SpanData)this.actual).getStatus().equals(status)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getStatus(), status, "Expected span [%s] to have status <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), status, ((SpanData)this.actual).getStatus()});
        }
        return this;
    }

    public SpanDataAssert endsAt(long endEpochNanos) {
        this.isNotNull();
        if (((SpanData)this.actual).getEndEpochNanos() != endEpochNanos) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getEndEpochNanos(), endEpochNanos, "Expected span [%s] to have end epoch <%s> nanos but was <%s>", new Object[]{((SpanData)this.actual).getName(), endEpochNanos, ((SpanData)this.actual).getEndEpochNanos()});
        }
        return this;
    }

    public SpanDataAssert endsAt(long startEpoch, TimeUnit unit) {
        return this.endsAt(unit.toNanos(startEpoch));
    }

    public SpanDataAssert endsAt(Instant timestamp) {
        return this.endsAt(SpanDataAssert.toNanos(timestamp));
    }

    public SpanDataAssert hasEnded() {
        this.isNotNull();
        if (!((SpanData)this.actual).hasEnded()) {
            this.failWithMessage("Expected span [%s] to have ended but did not", new Object[]{((SpanData)this.actual).getName()});
        }
        return this;
    }

    public SpanDataAssert hasNotEnded() {
        this.isNotNull();
        if (((SpanData)this.actual).hasEnded()) {
            this.failWithMessage("Expected span [%s] to have not ended but did has", new Object[]{((SpanData)this.actual).getName()});
        }
        return this;
    }

    public SpanDataAssert hasTotalRecordedEvents(int totalRecordedEvents) {
        this.isNotNull();
        if (((SpanData)this.actual).getTotalRecordedEvents() != totalRecordedEvents) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getTotalRecordedEvents(), totalRecordedEvents, "Expected span [%s] to have recorded <%s> total events but did not", new Object[]{((SpanData)this.actual).getName(), totalRecordedEvents, ((SpanData)this.actual).getTotalRecordedEvents()});
        }
        return this;
    }

    public SpanDataAssert hasTotalRecordedLinks(int totalRecordedLinks) {
        this.isNotNull();
        if (((SpanData)this.actual).getTotalRecordedLinks() != totalRecordedLinks) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getTotalRecordedLinks(), totalRecordedLinks, "Expected span [%s] to have recorded <%s> total links but did not", new Object[]{((SpanData)this.actual).getName(), totalRecordedLinks, ((SpanData)this.actual).getTotalRecordedLinks()});
        }
        return this;
    }

    public SpanDataAssert hasTotalAttributeCount(int totalAttributeCount) {
        this.isNotNull();
        if (((SpanData)this.actual).getTotalAttributeCount() != totalAttributeCount) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getTotalAttributeCount(), totalAttributeCount, "Expected span [%s] to have recorded <%s> total attributes but did not", new Object[]{((SpanData)this.actual).getName(), totalAttributeCount, ((SpanData)this.actual).getTotalAttributeCount()});
        }
        return this;
    }

    private static long toNanos(Instant timestamp) {
        return TimeUnit.SECONDS.toNanos(timestamp.getEpochSecond()) + (long)timestamp.getNano();
    }
}

