/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.junit4;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.TracerSdkManagement;
import io.opentelemetry.sdk.trace.TracerSdkProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.List;
import org.junit.rules.ExternalResource;

public class OpenTelemetryRule
extends ExternalResource {
    private final OpenTelemetrySdk openTelemetry;
    private final InMemorySpanExporter spanExporter;
    private volatile OpenTelemetry previousGlobalOpenTelemetry;

    public static OpenTelemetryRule create() {
        InMemorySpanExporter spanExporter = InMemorySpanExporter.create();
        TracerSdkProvider tracerProvider = TracerSdkProvider.builder().build();
        tracerProvider.addSpanProcessor((SpanProcessor)SimpleSpanProcessor.builder((SpanExporter)spanExporter).build());
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).setTracerProvider((TracerProvider)tracerProvider).build();
        return new OpenTelemetryRule(openTelemetry, spanExporter);
    }

    private OpenTelemetryRule(OpenTelemetrySdk openTelemetry, InMemorySpanExporter spanExporter) {
        this.openTelemetry = openTelemetry;
        this.spanExporter = spanExporter;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public TracerSdkManagement getTracerManagement() {
        return this.openTelemetry.getTracerManagement();
    }

    public List<SpanData> getSpans() {
        return this.spanExporter.getFinishedSpanItems();
    }

    public void clearSpans() {
        this.spanExporter.reset();
    }

    protected void before() throws Throwable {
        this.previousGlobalOpenTelemetry = OpenTelemetry.get();
        OpenTelemetry.set((OpenTelemetry)this.openTelemetry);
        this.clearSpans();
    }

    protected void after() {
        OpenTelemetry.set((OpenTelemetry)this.previousGlobalOpenTelemetry);
    }
}

