/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.junit5;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.api.trace.propagation.HttpTraceContext;
import io.opentelemetry.context.propagation.DefaultContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.TracerSdkManagement;
import io.opentelemetry.sdk.trace.TracerSdkProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.List;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class OpenTelemetryExtension
implements BeforeEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private final OpenTelemetrySdk openTelemetry;
    private final InMemorySpanExporter spanExporter;
    private volatile OpenTelemetry previousGlobalOpenTelemetry;

    public static OpenTelemetryExtension create() {
        InMemorySpanExporter spanExporter = InMemorySpanExporter.create();
        TracerSdkProvider tracerProvider = TracerSdkProvider.builder().build();
        tracerProvider.addSpanProcessor((SpanProcessor)SimpleSpanProcessor.builder((SpanExporter)spanExporter).build());
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setPropagators(DefaultContextPropagators.builder().addTextMapPropagator((TextMapPropagator)HttpTraceContext.getInstance()).build()).setTracerProvider((TracerProvider)tracerProvider).build();
        return new OpenTelemetryExtension(openTelemetry, spanExporter);
    }

    private OpenTelemetryExtension(OpenTelemetrySdk openTelemetry, InMemorySpanExporter spanExporter) {
        this.openTelemetry = openTelemetry;
        this.spanExporter = spanExporter;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public TracerSdkManagement getTracerManagement() {
        return this.openTelemetry.getTracerManagement();
    }

    public List<SpanData> getSpans() {
        return this.spanExporter.getFinishedSpanItems();
    }

    public void clearSpans() {
        this.spanExporter.reset();
    }

    public void beforeEach(ExtensionContext context) {
        this.clearSpans();
    }

    public void beforeAll(ExtensionContext context) {
        this.previousGlobalOpenTelemetry = OpenTelemetry.get();
        OpenTelemetry.set((OpenTelemetry)this.openTelemetry);
    }

    public void afterAll(ExtensionContext context) {
        OpenTelemetry.set((OpenTelemetry)this.previousGlobalOpenTelemetry);
    }
}

