/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.context;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

public class StrictContextStorage
implements ContextStorage {
    private final ContextStorage delegate;
    private final BlockingQueue<CallerStackTrace> currentCallers;

    public static StrictContextStorage create(ContextStorage delegate) {
        return new StrictContextStorage(delegate);
    }

    private StrictContextStorage(ContextStorage delegate) {
        this.delegate = delegate;
        this.currentCallers = new LinkedBlockingDeque<CallerStackTrace>();
    }

    public Scope attach(Context context) {
        String className;
        int i;
        Scope scope = this.delegate.attach(context);
        CallerStackTrace caller = new CallerStackTrace(context);
        StackTraceElement[] stackTrace = caller.getStackTrace();
        for (i = 1; i < stackTrace.length && ((className = stackTrace[i].getClassName()).startsWith("io.opentelemetry.api.") || className.startsWith("io.opentelemetry.sdk.testing.context.SettableContextStorageProvider") || className.startsWith("io.opentelemetry.context.")); ++i) {
        }
        int from = i;
        stackTrace = Arrays.copyOfRange(stackTrace, from, stackTrace.length);
        caller.setStackTrace(stackTrace);
        return new StrictScope(scope, caller, this.currentCallers);
    }

    public Context current() {
        return this.delegate.current();
    }

    public void ensureAllClosed() {
        ArrayList leakedCallers = new ArrayList();
        this.currentCallers.drainTo(leakedCallers);
        Iterator iterator = leakedCallers.iterator();
        if (iterator.hasNext()) {
            CallerStackTrace caller = (CallerStackTrace)iterator.next();
            AssertionError toThrow = new AssertionError((Object)("Thread [" + caller.threadName + "] opened a scope of " + caller.context + " here:"));
            ((Throwable)((Object)toThrow)).setStackTrace(caller.getStackTrace());
            throw toThrow;
        }
    }

    private static class CallerStackTrace
    extends Throwable {
        private static final long serialVersionUID = 783294061323215387L;
        final String threadName = Thread.currentThread().getName();
        final long threadId = Thread.currentThread().getId();
        final Context context;

        CallerStackTrace(Context context) {
            super("Thread [" + Thread.currentThread().getName() + "] opened scope for " + context + " here:");
            this.context = context;
        }
    }

    private static final class StrictScope
    implements Scope {
        final Scope delegate;
        final BlockingQueue<CallerStackTrace> currentCallers;
        final CallerStackTrace caller;

        private StrictScope(Scope delegate, CallerStackTrace caller, BlockingQueue<CallerStackTrace> currentCallers) {
            this.delegate = delegate;
            this.currentCallers = currentCallers;
            this.caller = caller;
            this.currentCallers.add(caller);
        }

        public void close() {
            this.currentCallers.remove(this.caller);
            if (Thread.currentThread().getId() != this.caller.threadId) {
                throw new IllegalStateException(String.format("Thread [%s] opened scope, but thread [%s] closed it", this.caller.threadName, Thread.currentThread().getName()), this.caller);
            }
            this.delegate.close();
        }

        public String toString() {
            return this.caller.getMessage();
        }
    }
}

