/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.testing;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;

public class InMemoryMetricReader
implements MetricReader,
MetricReaderFactory {
    private final AggregationTemporality preferred;
    private volatile MetricProducer metricProducer;

    public static InMemoryMetricReader create() {
        return new InMemoryMetricReader(AggregationTemporality.CUMULATIVE);
    }

    public static InMemoryMetricReader createDelta() {
        return new InMemoryMetricReader(AggregationTemporality.DELTA);
    }

    @Deprecated
    public InMemoryMetricReader() {
        this(AggregationTemporality.CUMULATIVE);
    }

    private InMemoryMetricReader(AggregationTemporality preferred) {
        this.preferred = preferred;
    }

    public Collection<MetricData> collectAllMetrics() {
        MetricProducer metricProducer = this.metricProducer;
        if (metricProducer != null) {
            return metricProducer.collectAllMetrics();
        }
        return Collections.emptyList();
    }

    @Override
    public EnumSet<AggregationTemporality> getSupportedTemporality() {
        return EnumSet.of(AggregationTemporality.CUMULATIVE, AggregationTemporality.DELTA);
    }

    @Override
    public AggregationTemporality getPreferredTemporality() {
        return this.preferred;
    }

    @Override
    public CompletableResultCode flush() {
        MetricProducer metricProducer = this.metricProducer;
        if (metricProducer != null) {
            metricProducer.collectAllMetrics();
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public MetricReader apply(MetricProducer producer) {
        this.metricProducer = producer;
        return this;
    }
}

