/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.exemplar;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import java.util.List;

class FilteredExemplarReservoir
implements ExemplarReservoir {
    private final ExemplarFilter filter;
    private final ExemplarReservoir reservoir;

    FilteredExemplarReservoir(ExemplarFilter filter, ExemplarReservoir reservoir) {
        this.filter = filter;
        this.reservoir = reservoir;
    }

    @Override
    public void offerMeasurement(long value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerMeasurement(value, attributes, context);
        }
    }

    @Override
    public void offerMeasurement(double value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerMeasurement(value, attributes, context);
        }
    }

    @Override
    public List<ExemplarData> collectAndReset(Attributes pointAttributes) {
        return this.reservoir.collectAndReset(pointAttributes);
    }
}

