/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.RandomSupplier;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.view.Aggregation;
import io.opentelemetry.sdk.resources.Resource;

class SumAggregation
extends Aggregation {
    static final SumAggregation DEFAULT = new SumAggregation(AggregationTemporality.CUMULATIVE);
    private final AggregationTemporality temporality;

    SumAggregation(AggregationTemporality temporality) {
        this.temporality = temporality;
    }

    public AggregationTemporality getTemporality() {
        return this.temporality;
    }

    @Override
    public <T> Aggregator<T> createAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor instrumentDescriptor, MetricDescriptor metricDescriptor, ExemplarFilter exemplarFilter) {
        return AggregatorFactory.sum(this.temporality).create(resource, instrumentationLibraryInfo, instrumentDescriptor, metricDescriptor, () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.fixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault())));
    }

    public String toString() {
        return "SumAggregation(" + (Object)((Object)this.temporality) + ")";
    }
}

