/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.view.DefaultAggregation;
import io.opentelemetry.sdk.metrics.view.ExplicitBucketHistogramAggregation;
import io.opentelemetry.sdk.metrics.view.LastValueAggregation;
import io.opentelemetry.sdk.metrics.view.NoAggregation;
import io.opentelemetry.sdk.metrics.view.SumAggregation;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import javax.annotation.Nullable;

public abstract class Aggregation {
    Aggregation() {
    }

    @Nullable
    public abstract <T> Aggregator<T> createAggregator(Resource var1, InstrumentationLibraryInfo var2, InstrumentDescriptor var3, MetricDescriptor var4, ExemplarFilter var5);

    public static Aggregation none() {
        return NoAggregation.INSTANCE;
    }

    public static Aggregation defaultAggregation() {
        return DefaultAggregation.INSTANCE;
    }

    public static Aggregation sum(AggregationTemporality temporality) {
        return new SumAggregation(temporality);
    }

    public static Aggregation sum() {
        return SumAggregation.DEFAULT;
    }

    public static Aggregation lastValue() {
        return LastValueAggregation.INSTANCE;
    }

    public static Aggregation explictBucketHistogram() {
        return ExplicitBucketHistogramAggregation.DEFAULT;
    }

    public static Aggregation explicitBucketHistogram(AggregationTemporality temporality) {
        return Aggregation.explicitBucketHistogram(temporality, ExplicitBucketHistogramUtils.DEFAULT_HISTOGRAM_BUCKET_BOUNDARIES);
    }

    public static Aggregation explicitBucketHistogram(AggregationTemporality temporality, List<Double> bucketBoundaries) {
        return new ExplicitBucketHistogramAggregation(temporality, bucketBoundaries);
    }

    public static Aggregation histogram() {
        return Aggregation.explictBucketHistogram();
    }
}

