/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.CollectionHandle;
import io.opentelemetry.sdk.metrics.internal.state.EmptyMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.TemporalMetricStorage;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import io.opentelemetry.sdk.metrics.view.View;
import io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class AsynchronousMetricStorage<T>
implements MetricStorage {
    private final MetricDescriptor metricDescriptor;
    private final ReentrantLock collectLock = new ReentrantLock();
    private final AsyncAccumulator<T> asyncAccumulator;
    private final TemporalMetricStorage<T> storage;
    private final Runnable metricUpdater;
    private static final Logger logger = Logger.getLogger(AsynchronousMetricStorage.class.getName());

    public static MetricStorage empty() {
        return EmptyMetricStorage.INSTANCE;
    }

    @Nullable
    public static <T> MetricStorage doubleAsynchronousAccumulator(View view, InstrumentDescriptor instrument, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, Consumer<ObservableDoubleMeasurement> metricUpdater) {
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, instrument);
        final Aggregator aggregator = view.getAggregation().createAggregator(resource, instrumentationLibraryInfo, instrument, metricDescriptor, ExemplarFilter.neverSample());
        final AsyncAccumulator measurementAccumulator = new AsyncAccumulator();
        if (Aggregator.empty() == aggregator) {
            return AsynchronousMetricStorage.empty();
        }
        final AttributesProcessor attributesProcessor = view.getAttributesProcessor();
        ObservableDoubleMeasurement result = new ObservableDoubleMeasurement(){

            public void observe(double value, Attributes attributes) {
                measurementAccumulator.record(attributesProcessor.process(attributes, Context.current()), aggregator.accumulateDouble(value));
            }

            public void observe(double value) {
                this.observe(value, Attributes.empty());
            }
        };
        return new AsynchronousMetricStorage(metricDescriptor, aggregator, measurementAccumulator, () -> metricUpdater.accept(result));
    }

    public static <T> MetricStorage longAsynchronousAccumulator(View view, InstrumentDescriptor instrument, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, Consumer<ObservableLongMeasurement> metricUpdater) {
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, instrument);
        final Aggregator aggregator = view.getAggregation().createAggregator(resource, instrumentationLibraryInfo, instrument, metricDescriptor, ExemplarFilter.neverSample());
        if (aggregator.isStateful()) {
            logger.warning(String.format("Unable to provide DELTA accumulation on %s for instrument: %s", metricDescriptor, instrument));
        }
        final AsyncAccumulator measurementAccumulator = new AsyncAccumulator();
        final AttributesProcessor attributesProcessor = view.getAttributesProcessor();
        ObservableLongMeasurement result = new ObservableLongMeasurement(){

            public void observe(long value, Attributes attributes) {
                measurementAccumulator.record(attributesProcessor.process(attributes, Context.current()), aggregator.accumulateLong(value));
            }

            public void observe(long value) {
                this.observe(value, Attributes.empty());
            }
        };
        return new AsynchronousMetricStorage(metricDescriptor, aggregator, measurementAccumulator, () -> metricUpdater.accept(result));
    }

    private AsynchronousMetricStorage(MetricDescriptor metricDescriptor, Aggregator<T> aggregator, AsyncAccumulator<T> asyncAccumulator, Runnable metricUpdater) {
        this.metricDescriptor = metricDescriptor;
        this.asyncAccumulator = asyncAccumulator;
        this.metricUpdater = metricUpdater;
        this.storage = new TemporalMetricStorage<T>(aggregator, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public MetricData collectAndReset(CollectionHandle collector, Set<CollectionHandle> allCollectors, long startEpochNanos, long epochNanos, boolean suppressSynchronousCollection) {
        this.collectLock.lock();
        try {
            this.metricUpdater.run();
            MetricData metricData = this.storage.buildMetricFor(collector, this.asyncAccumulator.collectAndReset(), startEpochNanos, epochNanos);
            return metricData;
        }
        finally {
            this.collectLock.unlock();
        }
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    private static final class AsyncAccumulator<T> {
        private Map<Attributes, T> currentAccumulation = new HashMap<Attributes, T>();

        private AsyncAccumulator() {
        }

        public void record(Attributes attributes, T accumulation) {
            this.currentAccumulation.put(attributes, accumulation);
        }

        public Map<Attributes, T> collectAndReset() {
            Map<Attributes, T> result = this.currentAccumulation;
            this.currentAccumulation = new HashMap<Attributes, T>();
            return result;
        }
    }
}

