/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleMinMaxSumCountAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.LongMinMaxSumCountAggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.function.Supplier;

final class MinMaxSumCountAggregatorFactory
implements AggregatorFactory {
    static final AggregatorFactory INSTANCE = new MinMaxSumCountAggregatorFactory();

    private MinMaxSumCountAggregatorFactory() {
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor instrumentDescriptor, MetricDescriptor metricDescriptor, Supplier<ExemplarReservoir> reservoirSupplier) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                return new LongMinMaxSumCountAggregator(resource, instrumentationLibraryInfo, metricDescriptor, reservoirSupplier);
            }
            case DOUBLE: {
                return new DoubleMinMaxSumCountAggregator(resource, instrumentationLibraryInfo, metricDescriptor, reservoirSupplier);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

