/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.DoubleHistogramPointData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.HistogramAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.LongAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.MinMaxSumCountAccumulation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class MetricDataUtils {
    private MetricDataUtils() {
    }

    static List<LongPointData> toLongPointList(Map<Attributes, LongAccumulation> accumulationMap, long startEpochNanos, long epochNanos) {
        ArrayList<LongPointData> points = new ArrayList<LongPointData>(accumulationMap.size());
        accumulationMap.forEach((labels, accumulation) -> points.add(LongPointData.create(startEpochNanos, epochNanos, labels, accumulation.getValue(), accumulation.getExemplars())));
        return points;
    }

    static List<DoublePointData> toDoublePointList(Map<Attributes, DoubleAccumulation> accumulationMap, long startEpochNanos, long epochNanos) {
        ArrayList<DoublePointData> points = new ArrayList<DoublePointData>(accumulationMap.size());
        accumulationMap.forEach((labels, accumulation) -> points.add(DoublePointData.create(startEpochNanos, epochNanos, labels, accumulation.getValue(), accumulation.getExemplars())));
        return points;
    }

    static List<DoubleSummaryPointData> toDoubleSummaryPointList(Map<Attributes, MinMaxSumCountAccumulation> accumulationMap, long startEpochNanos, long epochNanos) {
        ArrayList<DoubleSummaryPointData> points = new ArrayList<DoubleSummaryPointData>(accumulationMap.size());
        accumulationMap.forEach((labels, aggregator) -> points.add(aggregator.toPoint(startEpochNanos, epochNanos, (Attributes)labels)));
        return points;
    }

    static List<DoubleHistogramPointData> toDoubleHistogramPointList(Map<Attributes, HistogramAccumulation> accumulationMap, long startEpochNanos, long epochNanos, List<Double> boundaries) {
        ArrayList<DoubleHistogramPointData> points = new ArrayList<DoubleHistogramPointData>(accumulationMap.size());
        accumulationMap.forEach((labels, aggregator) -> {
            ArrayList<Long> counts = new ArrayList<Long>(aggregator.getCounts().length);
            for (long v : aggregator.getCounts()) {
                counts.add(v);
            }
            points.add(DoubleHistogramPointData.create(startEpochNanos, epochNanos, labels, aggregator.getSum(), boundaries, counts, aggregator.getExemplars()));
        });
        return points;
    }
}

