/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.InstrumentProcessor;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import io.opentelemetry.sdk.metrics.processor.LabelsProcessor;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class SynchronousMetricStorage<T>
implements WriteableMetricStorage {
    private final MetricDescriptor metricDescriptor;
    private final ConcurrentHashMap<Attributes, AggregatorHandle<T>> aggregatorLabels;
    private final ReentrantLock collectLock;
    private final Aggregator<T> aggregator;
    private final InstrumentProcessor<T> instrumentProcessor;
    private final LabelsProcessor labelsProcessor;

    public static <T> SynchronousMetricStorage<T> create(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, InstrumentDescriptor descriptor) {
        Aggregator aggregator = meterProviderSharedState.getAggregator(meterSharedState, descriptor);
        return new SynchronousMetricStorage(MetricDescriptor.create(descriptor.getName(), descriptor.getDescription(), descriptor.getUnit()), aggregator, new InstrumentProcessor(aggregator, meterProviderSharedState.getStartEpochNanos()), meterProviderSharedState.getLabelsProcessor(meterSharedState, descriptor));
    }

    SynchronousMetricStorage(MetricDescriptor metricDescriptor, Aggregator<T> aggregator, InstrumentProcessor<T> instrumentProcessor, LabelsProcessor labelsProcessor) {
        this.metricDescriptor = metricDescriptor;
        this.aggregatorLabels = new ConcurrentHashMap();
        this.collectLock = new ReentrantLock();
        this.aggregator = aggregator;
        this.instrumentProcessor = instrumentProcessor;
        this.labelsProcessor = labelsProcessor;
    }

    @Override
    public BoundStorageHandle bind(Attributes attributes) {
        AggregatorHandle<T> boundAggregatorHandle;
        Objects.requireNonNull(attributes, "attributes");
        attributes = this.labelsProcessor.onLabelsBound(Context.current(), attributes);
        AggregatorHandle<T> aggregatorHandle = this.aggregatorLabels.get(attributes);
        if (aggregatorHandle != null && aggregatorHandle.acquire()) {
            return aggregatorHandle;
        }
        aggregatorHandle = this.aggregator.createHandle();
        while ((boundAggregatorHandle = this.aggregatorLabels.putIfAbsent(attributes, aggregatorHandle)) != null) {
            if (boundAggregatorHandle.acquire()) {
                return boundAggregatorHandle;
            }
            this.aggregatorLabels.remove(attributes, boundAggregatorHandle);
        }
        return aggregatorHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetricData collectAndReset(long startEpochNanos, long epochNanos) {
        this.collectLock.lock();
        try {
            for (Map.Entry<Attributes, AggregatorHandle<T>> entry : this.aggregatorLabels.entrySet()) {
                T accumulation;
                boolean unmappedEntry = entry.getValue().tryUnmap();
                if (unmappedEntry) {
                    this.aggregatorLabels.remove(entry.getKey(), entry.getValue());
                }
                if ((accumulation = entry.getValue().accumulateThenReset()) == null) continue;
                this.instrumentProcessor.batch(entry.getKey(), accumulation);
            }
            MetricData metricData = this.instrumentProcessor.completeCollectionCycle(epochNanos);
            return metricData;
        }
        finally {
            this.collectLock.unlock();
        }
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }
}

