/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.state.AsynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.AutoValue_MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorageRegistry;
import io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class MeterSharedState {
    public static MeterSharedState create(InstrumentationLibraryInfo instrumentationLibraryInfo) {
        return new AutoValue_MeterSharedState(instrumentationLibraryInfo, new MetricStorageRegistry());
    }

    public abstract InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    abstract MetricStorageRegistry getMetricStorageRegistry();

    public List<MetricData> collectAll(MeterProviderSharedState meterProviderSharedState, long epochNanos) {
        Collection<MetricStorage> metrics = this.getMetricStorageRegistry().getMetrics();
        ArrayList<MetricData> result = new ArrayList<MetricData>(metrics.size());
        for (MetricStorage metric : metrics) {
            MetricData current = metric.collectAndReset(meterProviderSharedState.getStartEpochNanos(), epochNanos);
            if (current == null) continue;
            result.add(current);
        }
        return result;
    }

    public final WriteableMetricStorage registerSynchronousMetricStorage(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState) {
        return this.getMetricStorageRegistry().register(SynchronousMetricStorage.create(meterProviderSharedState, this, instrument));
    }

    public final MetricStorage registerLongAsynchronousInstrument(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState, Consumer<ObservableLongMeasurement> metricUpdater) {
        return this.getMetricStorageRegistry().register(AsynchronousMetricStorage.longAsynchronousAccumulator(meterProviderSharedState, this, instrument, metricUpdater));
    }

    public final MetricStorage registerDoubleAsynchronousInstrument(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState, Consumer<ObservableDoubleMeasurement> metricUpdater) {
        return this.getMetricStorageRegistry().register(AsynchronousMetricStorage.doubleAsynchronousAccumulator(meterProviderSharedState, this, instrument, metricUpdater));
    }
}

