/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.HashMap;
import java.util.Map;

final class InstrumentProcessor<T> {
    private final Aggregator<T> aggregator;
    private final long startEpochNanos;
    private long lastEpochNanos;
    private Map<Attributes, T> accumulationMap;

    InstrumentProcessor(Aggregator<T> aggregator, long startEpochNanos) {
        this.aggregator = aggregator;
        this.startEpochNanos = startEpochNanos;
        this.lastEpochNanos = startEpochNanos;
        this.accumulationMap = new HashMap<Attributes, T>();
    }

    void batch(Attributes attributes, T accumulation) {
        T currentAccumulation = this.accumulationMap.putIfAbsent(attributes, accumulation);
        if (currentAccumulation != null) {
            this.accumulationMap.put(attributes, this.aggregator.merge(currentAccumulation, accumulation));
        }
    }

    MetricData completeCollectionCycle(long epochNanos) {
        if (this.accumulationMap.isEmpty()) {
            return null;
        }
        MetricData metricData = this.aggregator.toMetricData(this.accumulationMap, this.startEpochNanos, this.lastEpochNanos, epochNanos);
        this.lastEpochNanos = epochNanos;
        if (!this.aggregator.isStateful()) {
            this.accumulationMap = new HashMap<Attributes, T>();
        }
        return metricData;
    }
}

