/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AggregatorHandle<T>
implements BoundStorageHandle {
    private final AtomicLong refCountMapped = new AtomicLong(2L);
    private volatile boolean hasRecordings = false;

    protected AggregatorHandle() {
    }

    public final boolean acquire() {
        return (this.refCountMapped.addAndGet(2L) & 1L) == 0L;
    }

    @Override
    public final void release() {
        this.refCountMapped.getAndAdd(-2L);
    }

    public final boolean tryUnmap() {
        if (this.refCountMapped.get() != 0L) {
            return false;
        }
        return this.refCountMapped.compareAndSet(0L, 1L);
    }

    @Nullable
    public final T accumulateThenReset() {
        if (!this.hasRecordings) {
            return null;
        }
        this.hasRecordings = false;
        return this.doAccumulateThenReset();
    }

    protected abstract T doAccumulateThenReset();

    public final void recordLong(long value) {
        this.doRecordLong(value);
        this.hasRecordings = true;
    }

    @Override
    public final void recordLong(long value, Attributes attributes, Context context) {
        this.recordLong(value);
    }

    protected void doRecordLong(long value) {
        throw new UnsupportedOperationException("This aggregator does not support recording long values.");
    }

    public final void recordDouble(double value) {
        this.doRecordDouble(value);
        this.hasRecordings = true;
    }

    @Override
    public final void recordDouble(double value, Attributes attributes, Context context) {
        this.recordDouble(value);
    }

    protected void doRecordDouble(double value) {
        throw new UnsupportedOperationException("This aggregator does not support recording double values.");
    }
}

