/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongCounterBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.DoubleGaugeBuilderSdk;
import io.opentelemetry.sdk.metrics.DoubleHistogramSdk;
import io.opentelemetry.sdk.metrics.LongCounterSdk;
import io.opentelemetry.sdk.metrics.LongUpDownCounterSdk;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import java.util.Collection;

final class SdkMeter
implements Meter {
    private final MeterProviderSharedState meterProviderSharedState;
    private final MeterSharedState meterSharedState;

    SdkMeter(MeterProviderSharedState meterProviderSharedState, InstrumentationLibraryInfo instrumentationLibraryInfo) {
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = MeterSharedState.create(instrumentationLibraryInfo);
    }

    InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.meterSharedState.getInstrumentationLibraryInfo();
    }

    Collection<MetricData> collectAll(long epochNanos) {
        return this.meterSharedState.collectAll(this.meterProviderSharedState, epochNanos);
    }

    public LongCounterBuilder counterBuilder(String name) {
        return new LongCounterSdk.Builder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    public LongUpDownCounterBuilder upDownCounterBuilder(String name) {
        return new LongUpDownCounterSdk.Builder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    public DoubleHistogramBuilder histogramBuilder(String name) {
        return new DoubleHistogramSdk.Builder(this.meterProviderSharedState, this.meterSharedState, name);
    }

    public DoubleGaugeBuilder gaugeBuilder(String name) {
        return new DoubleGaugeBuilderSdk(this.meterProviderSharedState, this.meterSharedState, name);
    }
}

