/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BoundLongUpDownCounter;
import io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.DoubleUpDownCounterSdk;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.function.Consumer;

final class LongUpDownCounterSdk
extends AbstractInstrument
implements LongUpDownCounter {
    private final WriteableMetricStorage storage;

    private LongUpDownCounterSdk(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    public void add(long increment, Attributes attributes, Context context) {
        this.storage.recordLong(increment, attributes, context);
    }

    public void add(long increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    public void add(long increment) {
        this.add(increment, Attributes.empty());
    }

    public BoundLongUpDownCounter bind(Attributes attributes) {
        return new BoundInstrument(this.storage.bind(attributes), attributes);
    }

    static final class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements LongUpDownCounterBuilder {
        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            this(meterProviderSharedState, meterSharedState, name, "", "1");
        }

        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit) {
            super(meterProviderSharedState, sharedState, name, description, unit);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public LongUpDownCounter build() {
            return this.buildSynchronousInstrument(InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.LONG, (x$0, x$1) -> new LongUpDownCounterSdk((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        public DoubleUpDownCounterBuilder ofDoubles() {
            return this.swapBuilder(DoubleUpDownCounterSdk.Builder::new);
        }

        public void buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            this.registerLongAsynchronousInstrument(InstrumentType.OBSERVABLE_UP_DOWN_SUM, callback);
        }
    }

    static final class BoundInstrument
    implements BoundLongUpDownCounter {
        private final BoundStorageHandle handle;
        private final Attributes attributes;

        BoundInstrument(BoundStorageHandle handle, Attributes attributes) {
            this.handle = handle;
            this.attributes = attributes;
        }

        public void add(long increment, Context context) {
            this.handle.recordLong(increment, this.attributes, context);
        }

        public void add(long increment) {
            this.add(increment, Context.current());
        }

        public void unbind() {
            this.handle.release();
        }
    }
}

