/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import java.util.List;

class MultiBoundStorageHandle
implements BoundStorageHandle {
    private final List<BoundStorageHandle> underlyingHandles;

    MultiBoundStorageHandle(List<BoundStorageHandle> handles) {
        this.underlyingHandles = handles;
    }

    @Override
    public void recordLong(long value, Attributes attributes, Context context) {
        for (BoundStorageHandle handle : this.underlyingHandles) {
            handle.recordLong(value, attributes, context);
        }
    }

    @Override
    public void recordDouble(double value, Attributes attributes, Context context) {
        for (BoundStorageHandle handle : this.underlyingHandles) {
            handle.recordDouble(value, attributes, context);
        }
    }

    @Override
    public void release() {
        for (BoundStorageHandle handle : this.underlyingHandles) {
            handle.release();
        }
    }
}

