/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.export;

import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class CollectionHandle {
    private final int index;

    private CollectionHandle(int index) {
        this.index = index;
    }

    public static Set<CollectionHandle> mutableSet() {
        return new CollectionHandleSet();
    }

    static Set<CollectionHandle> of(CollectionHandle ... handles) {
        Set<CollectionHandle> result = CollectionHandle.mutableSet();
        for (CollectionHandle handle : handles) {
            result.add(handle);
        }
        return result;
    }

    public static Supplier<CollectionHandle> createSupplier() {
        return new Supplier<CollectionHandle>(){
            private final AtomicInteger nextIndex = new AtomicInteger(1);

            @Override
            public CollectionHandle get() {
                return new CollectionHandle(this.nextIndex.getAndIncrement());
            }
        };
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof CollectionHandle)) {
            return false;
        }
        return this.index == ((CollectionHandle)other).index;
    }

    public String toString() {
        return "CollectionHandle(" + this.index + ")";
    }

    private static class CollectionHandleSet
    extends AbstractSet<CollectionHandle> {
        private final BitSet storage = new BitSet();

        private CollectionHandleSet() {
        }

        @Override
        public Iterator<CollectionHandle> iterator() {
            return new MyIterator();
        }

        @Override
        public boolean add(CollectionHandle handle) {
            if (this.storage.get(handle.index)) {
                return false;
            }
            this.storage.set(handle.index);
            return true;
        }

        @Override
        public boolean contains(Object handle) {
            if (handle instanceof CollectionHandle) {
                return this.storage.get(((CollectionHandle)handle).index);
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> other) {
            if (other instanceof CollectionHandleSet) {
                BitSet result = (BitSet)this.storage.clone();
                BitSet otherStorage = ((CollectionHandleSet)other).storage;
                result.and(otherStorage);
                return result.equals(otherStorage);
            }
            return super.containsAll(other);
        }

        @Override
        public int size() {
            return this.storage.cardinality();
        }

        private class MyIterator
        implements Iterator<CollectionHandle> {
            private int currentIndex = 0;

            private MyIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.currentIndex != -1 && CollectionHandleSet.this.storage.nextSetBit(this.currentIndex) != -1;
            }

            @Override
            public CollectionHandle next() {
                int result = CollectionHandleSet.this.storage.nextSetBit(this.currentIndex);
                if (result != -1) {
                    this.currentIndex = result + 1;
                    return new CollectionHandle(result);
                }
                throw new NoSuchElementException("Called `.next` on iterator with no remaining values.");
            }
        }
    }
}

