/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.CollectionInfo;
import io.opentelemetry.sdk.metrics.internal.state.AsynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.AutoValue_MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.DebugUtils;
import io.opentelemetry.sdk.metrics.internal.state.DuplicateMetricStorageException;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorageRegistry;
import io.opentelemetry.sdk.metrics.internal.state.MultiWritableMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class MeterSharedState {
    private static final Logger logger = Logger.getLogger(MeterSharedState.class.getName());

    public static MeterSharedState create(InstrumentationLibraryInfo instrumentationLibraryInfo) {
        return new AutoValue_MeterSharedState(instrumentationLibraryInfo, new MetricStorageRegistry());
    }

    public abstract InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    abstract MetricStorageRegistry getMetricStorageRegistry();

    public List<MetricData> collectAll(CollectionInfo collectionInfo, MeterProviderSharedState meterProviderSharedState, long epochNanos, boolean suppressSynchronousCollection) {
        Collection<MetricStorage> metrics = this.getMetricStorageRegistry().getMetrics();
        ArrayList<MetricData> result = new ArrayList<MetricData>(metrics.size());
        for (MetricStorage metric : metrics) {
            MetricData current = metric.collectAndReset(collectionInfo, meterProviderSharedState.getResource(), this.getInstrumentationLibraryInfo(), meterProviderSharedState.getStartEpochNanos(), epochNanos, suppressSynchronousCollection);
            if (current.isEmpty()) continue;
            result.add(current);
        }
        return result;
    }

    public final WriteableMetricStorage registerSynchronousMetricStorage(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState) {
        List<WriteableMetricStorage> storage = meterProviderSharedState.getViewRegistry().findViews(instrument, this.getInstrumentationLibraryInfo()).stream().map(view -> SynchronousMetricStorage.create(view, instrument, meterProviderSharedState.getExemplarFilter())).filter(m -> !m.isEmpty()).map(this::register).filter(Objects::nonNull).collect(Collectors.toList());
        if (storage.size() == 1) {
            return (WriteableMetricStorage)storage.get(0);
        }
        return new MultiWritableMetricStorage(storage);
    }

    public final void registerLongAsynchronousInstrument(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState, Consumer<ObservableLongMeasurement> metricUpdater) {
        meterProviderSharedState.getViewRegistry().findViews(instrument, this.getInstrumentationLibraryInfo()).stream().map(view -> AsynchronousMetricStorage.longAsynchronousAccumulator(view, instrument, metricUpdater)).filter(m -> !m.isEmpty()).forEach(this::register);
    }

    public final void registerDoubleAsynchronousInstrument(InstrumentDescriptor instrument, MeterProviderSharedState meterProviderSharedState, Consumer<ObservableDoubleMeasurement> metricUpdater) {
        meterProviderSharedState.getViewRegistry().findViews(instrument, this.getInstrumentationLibraryInfo()).stream().map(view -> AsynchronousMetricStorage.doubleAsynchronousAccumulator(view, instrument, metricUpdater)).filter(m -> !m.isEmpty()).forEach(this::register);
    }

    @Nullable
    private <S extends MetricStorage> S register(S storage) {
        try {
            return this.getMetricStorageRegistry().register(storage);
        }
        catch (DuplicateMetricStorageException e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, DebugUtils.duplicateMetricErrorMessage(e), e);
            }
            return null;
        }
    }
}

