/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.internal.ThrowableUtil;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.EmptyMetricData;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.CollectionInfo;
import io.opentelemetry.sdk.metrics.internal.state.DeltaMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.EmptyMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.TemporalMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.TemporalityUtils;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import io.opentelemetry.sdk.metrics.view.View;
import io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AsynchronousMetricStorage<T>
implements MetricStorage {
    private static final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(DeltaMetricStorage.class.getName()));
    private final MetricDescriptor metricDescriptor;
    private final ReentrantLock collectLock = new ReentrantLock();
    private final AsyncAccumulator<T> asyncAccumulator;
    private final TemporalMetricStorage<T> storage;
    private final Runnable metricUpdater;

    public static MetricStorage empty() {
        return EmptyMetricStorage.INSTANCE;
    }

    public static <T> MetricStorage doubleAsynchronousAccumulator(View view, InstrumentDescriptor instrument, Consumer<ObservableDoubleMeasurement> metricUpdater) {
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, instrument);
        final Aggregator aggregator = view.getAggregation().createAggregator(instrument, ExemplarFilter.neverSample());
        final AsyncAccumulator measurementAccumulator = new AsyncAccumulator(instrument);
        if (Aggregator.drop() == aggregator) {
            return AsynchronousMetricStorage.empty();
        }
        final AttributesProcessor attributesProcessor = view.getAttributesProcessor();
        ObservableDoubleMeasurement result = new ObservableDoubleMeasurement(){

            public void record(double value, Attributes attributes) {
                Object accumulation = aggregator.accumulateDoubleMeasurement(value, attributes, Context.current());
                if (accumulation != null) {
                    measurementAccumulator.record(attributesProcessor.process(attributes, Context.current()), accumulation);
                }
            }

            public void record(double value) {
                this.record(value, Attributes.empty());
            }
        };
        return new AsynchronousMetricStorage(metricDescriptor, aggregator, measurementAccumulator, () -> metricUpdater.accept(result));
    }

    public static <T> MetricStorage longAsynchronousAccumulator(View view, InstrumentDescriptor instrument, Consumer<ObservableLongMeasurement> metricUpdater) {
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, instrument);
        final Aggregator aggregator = view.getAggregation().createAggregator(instrument, ExemplarFilter.neverSample());
        final AsyncAccumulator measurementAccumulator = new AsyncAccumulator(instrument);
        final AttributesProcessor attributesProcessor = view.getAttributesProcessor();
        ObservableLongMeasurement result = new ObservableLongMeasurement(){

            public void record(long value, Attributes attributes) {
                Object accumulation = aggregator.accumulateLongMeasurement(value, attributes, Context.current());
                if (accumulation != null) {
                    measurementAccumulator.record(attributesProcessor.process(attributes, Context.current()), accumulation);
                }
            }

            public void record(long value) {
                this.record(value, Attributes.empty());
            }
        };
        return new AsynchronousMetricStorage(metricDescriptor, aggregator, measurementAccumulator, () -> metricUpdater.accept(result));
    }

    private AsynchronousMetricStorage(MetricDescriptor metricDescriptor, Aggregator<T> aggregator, AsyncAccumulator<T> asyncAccumulator, Runnable metricUpdater) {
        this.metricDescriptor = metricDescriptor;
        this.asyncAccumulator = asyncAccumulator;
        this.metricUpdater = metricUpdater;
        this.storage = new TemporalMetricStorage<T>(aggregator, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetricData collectAndReset(CollectionInfo collectionInfo, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, long startEpochNanos, long epochNanos, boolean suppressSynchronousCollection) {
        AggregationTemporality temporality = TemporalityUtils.resolveTemporality(collectionInfo.getPreferredAggregation());
        this.collectLock.lock();
        try {
            try {
                this.metricUpdater.run();
            }
            catch (Throwable e) {
                ThrowableUtil.propagateIfFatal((Throwable)e);
                logger.log(Level.WARNING, "An exception occurred invoking callback for instrument " + this.getMetricDescriptor().getName() + ".", e);
                MetricData metricData = EmptyMetricData.getInstance();
                this.collectLock.unlock();
                return metricData;
            }
            MetricData metricData = this.storage.buildMetricFor(collectionInfo.getCollector(), resource, instrumentationLibraryInfo, this.getMetricDescriptor(), temporality, this.asyncAccumulator.collectAndReset(), startEpochNanos, epochNanos);
            return metricData;
        }
        finally {
            this.collectLock.unlock();
        }
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    private static final class AsyncAccumulator<T> {
        private final InstrumentDescriptor instrument;
        private Map<Attributes, T> currentAccumulation = new HashMap<Attributes, T>();

        AsyncAccumulator(InstrumentDescriptor instrument) {
            this.instrument = instrument;
        }

        public void record(Attributes attributes, T accumulation) {
            if (this.currentAccumulation.size() >= 2000) {
                logger.log(Level.WARNING, "Instrument " + this.instrument.getName() + " has exceeded the maximum allowed accumulations (" + 2000 + ").");
                return;
            }
            this.currentAccumulation.put(attributes, accumulation);
        }

        public Map<Attributes, T> collectAndReset() {
            Map<Attributes, T> result = this.currentAccumulation;
            this.currentAccumulation = new HashMap<Attributes, T>();
            return result;
        }
    }
}

