/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.SystemClock;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.view.InstrumentSelector;
import io.opentelemetry.sdk.metrics.view.View;
import io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class SdkMeterProviderBuilder {
    private Clock clock = SystemClock.getInstance();
    private Resource resource = Resource.getDefault();
    private final Map<InstrumentSelector, View> instrumentSelectorViews = new HashMap<InstrumentSelector, View>();

    SdkMeterProviderBuilder() {
    }

    public SdkMeterProviderBuilder setClock(@Nonnull Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkMeterProviderBuilder setResource(@Nonnull Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkMeterProviderBuilder registerView(InstrumentSelector selector, View view) {
        Objects.requireNonNull(selector, "selector");
        Objects.requireNonNull(view, "view");
        this.instrumentSelectorViews.put(selector, view);
        return this;
    }

    public SdkMeterProvider buildAndRegisterGlobal() {
        SdkMeterProvider meterProvider = this.build();
        GlobalMeterProvider.set((MeterProvider)meterProvider);
        return meterProvider;
    }

    public SdkMeterProvider build() {
        return new SdkMeterProvider(this.clock, this.resource, this.instrumentSelectorViews);
    }
}

