/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.data;

import com.google.auto.value.AutoValue;
import io.opentelemetry.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData_DoublePoint;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData_LongPoint;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData_SummaryPoint;
import io.opentelemetry.sdk.metrics.data.AutoValue_MetricData_ValueAtPercentile;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class MetricData {
    MetricData() {
    }

    public abstract Resource getResource();

    public abstract InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getUnit();

    public abstract Type getType();

    public abstract Collection<Point> getPoints();

    public static MetricData create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, String name, String description, String unit, Type type, Collection<Point> points) {
        return new AutoValue_MetricData(resource, instrumentationLibraryInfo, name, description, unit, type, points);
    }

    @Immutable
    @AutoValue
    public static abstract class ValueAtPercentile {
        ValueAtPercentile() {
        }

        public abstract double getPercentile();

        public abstract double getValue();

        public static ValueAtPercentile create(double percentile, double value) {
            return new AutoValue_MetricData_ValueAtPercentile(percentile, value);
        }
    }

    @Immutable
    @AutoValue
    public static abstract class SummaryPoint
    extends Point {
        SummaryPoint() {
        }

        public abstract long getCount();

        public abstract double getSum();

        public abstract List<ValueAtPercentile> getPercentileValues();

        public static SummaryPoint create(long startEpochNanos, long epochNanos, Labels labels, long count, double sum, List<ValueAtPercentile> percentileValues) {
            return new AutoValue_MetricData_SummaryPoint(startEpochNanos, epochNanos, labels, count, sum, percentileValues);
        }
    }

    @Immutable
    @AutoValue
    public static abstract class DoublePoint
    extends Point {
        DoublePoint() {
        }

        public abstract double getValue();

        public static DoublePoint create(long startEpochNanos, long epochNanos, Labels labels, double value) {
            return new AutoValue_MetricData_DoublePoint(startEpochNanos, epochNanos, labels, value);
        }
    }

    @Immutable
    @AutoValue
    public static abstract class LongPoint
    extends Point {
        LongPoint() {
        }

        public abstract long getValue();

        public static LongPoint create(long startEpochNanos, long epochNanos, Labels labels, long value) {
            return new AutoValue_MetricData_LongPoint(startEpochNanos, epochNanos, labels, value);
        }
    }

    @Immutable
    public static abstract class Point {
        Point() {
        }

        public abstract long getStartEpochNanos();

        public abstract long getEpochNanos();

        public abstract Labels getLabels();
    }

    public static enum Type {
        NON_MONOTONIC_LONG,
        NON_MONOTONIC_DOUBLE,
        MONOTONIC_LONG,
        MONOTONIC_DOUBLE,
        SUMMARY;

    }
}

