/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.DoubleSumAggregator;
import io.opentelemetry.sdk.metrics.aggregator.LongSumAggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.resources.Resource;

final class SumAggregatorFactory
implements AggregatorFactory {
    private final boolean alwaysCumulative;

    SumAggregatorFactory(boolean alwaysCumulative) {
        this.alwaysCumulative = alwaysCumulative;
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor) {
        boolean stateful = this.alwaysCumulative;
        if (descriptor.getType() == InstrumentType.SUM_OBSERVER || descriptor.getType() == InstrumentType.UP_DOWN_SUM_OBSERVER) {
            stateful = false;
        }
        switch (descriptor.getValueType()) {
            case LONG: {
                return new LongSumAggregator(resource, instrumentationLibraryInfo, descriptor, stateful);
            }
            case DOUBLE: {
                return new DoubleSumAggregator(resource, instrumentationLibraryInfo, descriptor, stateful);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

