/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.AbstractSumAggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.LongSumData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;

final class LongSumAggregator
extends AbstractSumAggregator<Long> {
    LongSumAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, boolean stateful) {
        super(resource, instrumentationLibraryInfo, descriptor, stateful);
    }

    @Override
    public AggregatorHandle<Long> createHandle() {
        return new Handle();
    }

    @Override
    public Long accumulateLong(long value) {
        return value;
    }

    @Override
    public Long merge(Long a1, Long a2) {
        return a1 + a2;
    }

    @Override
    public MetricData toMetricData(Map<Labels, Long> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        InstrumentDescriptor descriptor = this.getInstrumentDescriptor();
        return MetricData.createLongSum(this.getResource(), this.getInstrumentationLibraryInfo(), descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), LongSumData.create(this.isMonotonic(), this.temporality(), MetricDataUtils.toLongPointList(accumulationByLabels, this.temporality() == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<Long> {
        private final LongAdder current = new LongAdder();

        Handle() {
        }

        @Override
        protected Long doAccumulateThenReset() {
            return this.current.sumThenReset();
        }

        @Override
        public void doRecordLong(long value) {
            this.current.add(value);
        }
    }
}

