/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.aggregator.MinMaxSumCountAccumulation;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryData;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryPoint;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LongMinMaxSumCountAggregator
implements Aggregator<MinMaxSumCountAccumulation> {
    private static final LongMinMaxSumCountAggregator INSTANCE = new LongMinMaxSumCountAggregator();

    public static Aggregator<MinMaxSumCountAccumulation> getInstance() {
        return INSTANCE;
    }

    private LongMinMaxSumCountAggregator() {
    }

    @Override
    public AggregatorHandle<MinMaxSumCountAccumulation> createHandle() {
        return new Handle();
    }

    @Override
    public MinMaxSumCountAccumulation accumulateLong(long value) {
        return MinMaxSumCountAccumulation.create(1L, value, value, value);
    }

    @Override
    public MinMaxSumCountAccumulation merge(MinMaxSumCountAccumulation a1, MinMaxSumCountAccumulation a2) {
        return MinMaxSumCountAccumulation.create(a1.getCount() + a2.getCount(), a1.getSum() + a2.getSum(), Math.min(a1.getMin(), a2.getMin()), Math.max(a1.getMax(), a2.getMax()));
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, Map<Labels, MinMaxSumCountAccumulation> accumulationByLabels, long startEpochNanos, long epochNanos) {
        List<DoubleSummaryPoint> points = MetricDataUtils.toDoubleSummaryPointList(accumulationByLabels, startEpochNanos, epochNanos);
        return MetricData.createDoubleSummary(resource, instrumentationLibraryInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), DoubleSummaryData.create(points));
    }

    static final class Handle
    extends AggregatorHandle<MinMaxSumCountAccumulation> {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        @GuardedBy(value="lock")
        private final LongState current = new LongState();

        Handle() {
        }

        @Override
        protected MinMaxSumCountAccumulation doAccumulateThenReset() {
            this.lock.writeLock().lock();
            try {
                MinMaxSumCountAccumulation toReturn = MinMaxSumCountAccumulation.create(this.current.count, this.current.sum, this.current.min, this.current.max);
                this.current.reset();
                MinMaxSumCountAccumulation minMaxSumCountAccumulation = toReturn;
                return minMaxSumCountAccumulation;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.lock.writeLock().lock();
            try {
                this.current.record(value);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private static final class LongState {
            private long count;
            private long sum;
            private long min;
            private long max;

            public LongState() {
                this.reset();
            }

            private void reset() {
                this.sum = 0L;
                this.count = 0L;
                this.min = Long.MAX_VALUE;
                this.max = Long.MIN_VALUE;
            }

            public void record(long value) {
                ++this.count;
                this.sum += value;
                this.min = Math.min(value, this.min);
                this.max = Math.max(value, this.max);
            }
        }
    }
}

