/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.LongGaugeData;
import io.opentelemetry.sdk.metrics.data.LongPoint;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public final class LongLastValueAggregator
implements Aggregator<Long> {
    @Nullable
    private static final Long DEFAULT_VALUE = null;
    private static final LongLastValueAggregator INSTANCE = new LongLastValueAggregator();

    public static Aggregator<Long> getInstance() {
        return INSTANCE;
    }

    private LongLastValueAggregator() {
    }

    @Override
    public AggregatorHandle<Long> createHandle() {
        return new Handle();
    }

    @Override
    public Long accumulateLong(long value) {
        return value;
    }

    @Override
    public Long merge(Long a1, Long a2) {
        return a2;
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, Map<Labels, Long> accumulationByLabels, long startEpochNanos, long epochNanos) {
        List<LongPoint> points = MetricDataUtils.toLongPointList(accumulationByLabels, startEpochNanos, epochNanos);
        switch (descriptor.getType()) {
            case SUM_OBSERVER: {
                return MetricDataUtils.toLongSumMetricData(resource, instrumentationLibraryInfo, descriptor, points, true);
            }
            case UP_DOWN_SUM_OBSERVER: {
                return MetricDataUtils.toLongSumMetricData(resource, instrumentationLibraryInfo, descriptor, points, false);
            }
            case VALUE_OBSERVER: {
                return MetricData.createLongGauge(resource, instrumentationLibraryInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), LongGaugeData.create(points));
            }
        }
        return null;
    }

    static final class Handle
    extends AggregatorHandle<Long> {
        private final AtomicReference<Long> current = new AtomicReference<Long>(LongLastValueAggregator.access$000());

        Handle() {
        }

        @Override
        protected Long doAccumulateThenReset() {
            return this.current.getAndSet(DEFAULT_VALUE);
        }

        @Override
        protected void doRecordLong(long value) {
            this.current.set(value);
        }
    }
}

