/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.CountAggregator;
import io.opentelemetry.sdk.metrics.aggregator.DoubleLastValueAggregator;
import io.opentelemetry.sdk.metrics.aggregator.DoubleMinMaxSumCountAggregator;
import io.opentelemetry.sdk.metrics.aggregator.DoubleSumAggregator;
import io.opentelemetry.sdk.metrics.aggregator.LongLastValueAggregator;
import io.opentelemetry.sdk.metrics.aggregator.LongMinMaxSumCountAggregator;
import io.opentelemetry.sdk.metrics.aggregator.LongSumAggregator;
import io.opentelemetry.sdk.metrics.aggregator.MinMaxSumCountAccumulation;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ImmutableAggregatorFactory<L, D>
implements AggregatorFactory {
    static final AggregatorFactory SUM = new ImmutableAggregatorFactory<Long, Double>(LongSumAggregator.getInstance(), DoubleSumAggregator.getInstance());
    static final AggregatorFactory COUNT = new ImmutableAggregatorFactory<Long, Long>(CountAggregator.getInstance(), CountAggregator.getInstance());
    static final AggregatorFactory LAST_VALUE = new ImmutableAggregatorFactory<Long, Double>(LongLastValueAggregator.getInstance(), DoubleLastValueAggregator.getInstance());
    static final AggregatorFactory MIN_MAX_SUM_COUNT = new ImmutableAggregatorFactory<MinMaxSumCountAccumulation, MinMaxSumCountAccumulation>(LongMinMaxSumCountAggregator.getInstance(), DoubleMinMaxSumCountAggregator.getInstance());
    private final Aggregator<L> longAggregator;
    private final Aggregator<D> doubleAggregator;

    private ImmutableAggregatorFactory(Aggregator<L> longAggregator, Aggregator<D> doubleAggregator) {
        this.longAggregator = longAggregator;
        this.doubleAggregator = doubleAggregator;
    }

    @Override
    public <T> Aggregator<T> create(InstrumentDescriptor descriptor) {
        switch (descriptor.getValueType()) {
            case LONG: {
                return this.longAggregator;
            }
            case DOUBLE: {
                return this.doubleAggregator;
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

