/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.data.DoublePoint;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.DoubleAdder;

public final class DoubleSumAggregator
implements Aggregator<Double> {
    private static final DoubleSumAggregator INSTANCE = new DoubleSumAggregator();

    public static Aggregator<Double> getInstance() {
        return INSTANCE;
    }

    private DoubleSumAggregator() {
    }

    @Override
    public AggregatorHandle<Double> createHandle() {
        return new Handle();
    }

    @Override
    public Double accumulateDouble(double value) {
        return value;
    }

    @Override
    public final Double merge(Double a1, Double a2) {
        return a1 + a2;
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, Map<Labels, Double> accumulationByLabels, long startEpochNanos, long epochNanos) {
        List<DoublePoint> points = MetricDataUtils.toDoublePointList(accumulationByLabels, startEpochNanos, epochNanos);
        boolean isMonotonic = descriptor.getType() == InstrumentType.COUNTER || descriptor.getType() == InstrumentType.SUM_OBSERVER;
        return MetricDataUtils.toDoubleSumMetricData(resource, instrumentationLibraryInfo, descriptor, points, isMonotonic);
    }

    static final class Handle
    extends AggregatorHandle<Double> {
        private final DoubleAdder current = new DoubleAdder();

        Handle() {
        }

        @Override
        protected Double doAccumulateThenReset() {
            return this.current.sumThenReset();
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.add(value);
        }
    }
}

