/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.DoubleGaugeData;
import io.opentelemetry.sdk.metrics.data.DoublePoint;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DoubleLastValueAggregator
implements Aggregator<Double> {
    private static final DoubleLastValueAggregator INSTANCE = new DoubleLastValueAggregator();

    public static DoubleLastValueAggregator getInstance() {
        return INSTANCE;
    }

    private DoubleLastValueAggregator() {
    }

    @Override
    public AggregatorHandle<Double> createHandle() {
        return new Handle();
    }

    @Override
    public Double accumulateDouble(double value) {
        return value;
    }

    @Override
    public Double merge(Double a1, Double a2) {
        return a2;
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, Map<Labels, Double> accumulationByLabels, long startEpochNanos, long epochNanos) {
        List<DoublePoint> points = MetricDataUtils.toDoublePointList(accumulationByLabels, startEpochNanos, epochNanos);
        switch (descriptor.getType()) {
            case SUM_OBSERVER: {
                return MetricDataUtils.toDoubleSumMetricData(resource, instrumentationLibraryInfo, descriptor, points, true);
            }
            case UP_DOWN_SUM_OBSERVER: {
                return MetricDataUtils.toDoubleSumMetricData(resource, instrumentationLibraryInfo, descriptor, points, false);
            }
            case VALUE_OBSERVER: {
                return MetricData.createDoubleGauge(resource, instrumentationLibraryInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), DoubleGaugeData.create(points));
            }
        }
        return null;
    }

    static final class Handle
    extends AggregatorHandle<Double> {
        @Nullable
        private static final Double DEFAULT_VALUE = null;
        private final AtomicReference<Double> current = new AtomicReference<Double>(DEFAULT_VALUE);

        private Handle() {
        }

        @Override
        protected Double doAccumulateThenReset() {
            return this.current.getAndSet(DEFAULT_VALUE);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.set(value);
        }
    }
}

