/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.view.AggregationConfiguration;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class InstrumentProcessor<T> {
    private final InstrumentDescriptor descriptor;
    private final Aggregator<T> aggregator;
    private final Resource resource;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;
    private Map<Labels, T> accumulationMap;
    private long startEpochNanos;
    private final boolean delta;

    static <T> InstrumentProcessor<T> createProcessor(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, InstrumentDescriptor descriptor, AggregationConfiguration configuration) {
        Aggregator aggregator = configuration.getAggregatorFactory().create(descriptor);
        return new InstrumentProcessor(descriptor, aggregator, meterProviderSharedState.getResource(), meterSharedState.getInstrumentationLibraryInfo(), meterProviderSharedState.getStartEpochNanos(), InstrumentProcessor.isDelta(configuration.getTemporality()));
    }

    private InstrumentProcessor(InstrumentDescriptor descriptor, Aggregator<T> aggregator, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, long startEpochNanos, boolean delta) {
        this.descriptor = descriptor;
        this.aggregator = aggregator;
        this.resource = resource;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
        this.delta = delta;
        this.accumulationMap = new HashMap<Labels, T>();
        this.startEpochNanos = startEpochNanos;
    }

    void batch(Labels labelSet, T accumulation) {
        T currentAccumulation = this.accumulationMap.get(labelSet);
        if (currentAccumulation == null) {
            this.accumulationMap.put(labelSet, accumulation);
            return;
        }
        this.accumulationMap.put(labelSet, this.aggregator.merge(currentAccumulation, accumulation));
    }

    List<MetricData> completeCollectionCycle(long epochNanos) {
        if (this.accumulationMap.isEmpty()) {
            return Collections.emptyList();
        }
        MetricData metricData = this.aggregator.toMetricData(this.resource, this.instrumentationLibraryInfo, this.descriptor, this.accumulationMap, this.startEpochNanos, epochNanos);
        if (this.delta) {
            this.startEpochNanos = epochNanos;
            this.accumulationMap = new HashMap<Labels, T>();
        }
        return metricData == null ? Collections.emptyList() : Collections.singletonList(metricData);
    }

    private static boolean isDelta(AggregationTemporality temporality) {
        switch (temporality) {
            case CUMULATIVE: {
                return false;
            }
            case DELTA: {
                return true;
            }
        }
        throw new IllegalStateException("unsupported Temporality: " + (Object)((Object)temporality));
    }
}

