/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.api.metrics.DoubleValueRecorder;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrumentBuilder;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.SynchronousInstrumentAccumulator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class DoubleValueRecorderSdk
extends AbstractSynchronousInstrument
implements DoubleValueRecorder {
    private DoubleValueRecorderSdk(InstrumentDescriptor descriptor, SynchronousInstrumentAccumulator<?> accumulator) {
        super(descriptor, accumulator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(double value, Labels labels) {
        AggregatorHandle<?> aggregatorHandle = this.acquireHandle(labels);
        try {
            aggregatorHandle.recordDouble(value);
        }
        finally {
            aggregatorHandle.release();
        }
    }

    public void record(double value) {
        this.record(value, Labels.empty());
    }

    public DoubleValueRecorder.BoundDoubleValueRecorder bind(Labels labels) {
        return new BoundInstrument(this.acquireHandle(labels));
    }

    static final class Builder
    extends AbstractSynchronousInstrumentBuilder<Builder>
    implements DoubleValueRecorder.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, InstrumentType.VALUE_RECORDER, InstrumentValueType.DOUBLE, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public DoubleValueRecorderSdk build() {
            return this.buildInstrument((x$0, x$1) -> new DoubleValueRecorderSdk((InstrumentDescriptor)x$0, (SynchronousInstrumentAccumulator)x$1));
        }
    }

    static final class BoundInstrument
    implements DoubleValueRecorder.BoundDoubleValueRecorder {
        private final AggregatorHandle<?> aggregatorHandle;

        BoundInstrument(AggregatorHandle<?> aggregatorHandle) {
            this.aggregatorHandle = aggregatorHandle;
        }

        public void record(double value) {
            this.aggregatorHandle.recordDouble(value);
        }

        public void unbind() {
            this.aggregatorHandle.release();
        }
    }
}

