/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.view.;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class InstrumentSelector {
    public static Builder newBuilder() {
        return new .AutoValue_InstrumentSelector.Builder();
    }

    @Nullable
    public abstract InstrumentType instrumentType();

    @Nullable
    public abstract String instrumentNameRegex();

    @Nullable
    @Memoized
    public Pattern instrumentNamePattern() {
        return this.instrumentNameRegex() == null ? null : Pattern.compile(this.instrumentNameRegex());
    }

    public boolean hasInstrumentType() {
        return this.instrumentType() != null;
    }

    public boolean hasInstrumentNameRegex() {
        return this.instrumentNameRegex() != null;
    }

    @AutoValue.Builder
    public static interface Builder {
        public Builder instrumentType(InstrumentType var1);

        public Builder instrumentNameRegex(String var1);

        public InstrumentSelector build();
    }
}

