/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.DoubleLastValueAggregator;
import io.opentelemetry.sdk.metrics.aggregator.DoubleMinMaxSumCount;
import io.opentelemetry.sdk.metrics.aggregator.DoubleSumAggregator;
import io.opentelemetry.sdk.metrics.aggregator.LongLastValueAggregator;
import io.opentelemetry.sdk.metrics.aggregator.LongMinMaxSumCount;
import io.opentelemetry.sdk.metrics.aggregator.LongSumAggregator;
import io.opentelemetry.sdk.metrics.aggregator.NoopAggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.view.Aggregation;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public final class Aggregations {
    public static Aggregation sum() {
        return Sum.INSTANCE;
    }

    public static Aggregation count() {
        return Count.INSTANCE;
    }

    public static Aggregation lastValue() {
        return LastValue.INSTANCE;
    }

    public static Aggregation minMaxSumCount() {
        return MinMaxSumCount.INSTANCE;
    }

    @Nullable
    private static MetricData getSumMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, List<MetricData.Point> points, boolean isMonotonic) {
        switch (descriptor.getValueType()) {
            case LONG: {
                return MetricData.createLongSum(resource, instrumentationLibraryInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), MetricData.LongSumData.create(isMonotonic, MetricData.AggregationTemporality.CUMULATIVE, points));
            }
            case DOUBLE: {
                return MetricData.createDoubleSum(resource, instrumentationLibraryInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), MetricData.DoubleSumData.create(isMonotonic, MetricData.AggregationTemporality.CUMULATIVE, points));
            }
        }
        return null;
    }

    @Nullable
    private static MetricData getGaugeMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, List<MetricData.Point> points) {
        switch (descriptor.getValueType()) {
            case LONG: {
                return MetricData.createLongGauge(resource, instrumentationLibraryInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), MetricData.LongGaugeData.create(points));
            }
            case DOUBLE: {
                return MetricData.createDoubleGauge(resource, instrumentationLibraryInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), MetricData.DoubleGaugeData.create(points));
            }
        }
        return null;
    }

    private static List<MetricData.Point> getPointList(Map<Labels, Aggregator> aggregatorMap, long startEpochNanos, long epochNanos) {
        ArrayList<MetricData.Point> points = new ArrayList<MetricData.Point>(aggregatorMap.size());
        aggregatorMap.forEach((labels, aggregator) -> {
            MetricData.Point point = aggregator.toPoint(startEpochNanos, epochNanos, (Labels)labels);
            if (point == null) {
                return;
            }
            points.add(point);
        });
        return points;
    }

    private Aggregations() {
    }

    @Immutable
    private static enum LastValue implements Aggregation
    {
        INSTANCE;


        @Override
        public AggregatorFactory getAggregatorFactory(InstrumentValueType instrumentValueType) {
            return instrumentValueType == InstrumentValueType.LONG ? LongLastValueAggregator.getFactory() : DoubleLastValueAggregator.getFactory();
        }

        @Override
        public MetricData toMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, Map<Labels, Aggregator> aggregatorMap, long startEpochNanos, long epochNanos) {
            List points = Aggregations.getPointList(aggregatorMap, startEpochNanos, epochNanos);
            switch (descriptor.getType()) {
                case SUM_OBSERVER: {
                    return Aggregations.getSumMetricData(resource, instrumentationLibraryInfo, descriptor, points, true);
                }
                case UP_DOWN_SUM_OBSERVER: {
                    return Aggregations.getSumMetricData(resource, instrumentationLibraryInfo, descriptor, points, false);
                }
                case VALUE_OBSERVER: {
                    return Aggregations.getGaugeMetricData(resource, instrumentationLibraryInfo, descriptor, points);
                }
            }
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    @Immutable
    private static enum Count implements Aggregation
    {
        INSTANCE;


        @Override
        public AggregatorFactory getAggregatorFactory(InstrumentValueType instrumentValueType) {
            return NoopAggregator.getFactory();
        }

        @Override
        public MetricData toMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, Map<Labels, Aggregator> aggregatorMap, long startEpochNanos, long epochNanos) {
            List points = Aggregations.getPointList(aggregatorMap, startEpochNanos, epochNanos);
            return MetricData.createLongSum(resource, instrumentationLibraryInfo, descriptor.getName(), descriptor.getDescription(), "1", MetricData.LongSumData.create(true, MetricData.AggregationTemporality.CUMULATIVE, points));
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    @Immutable
    private static enum Sum implements Aggregation
    {
        INSTANCE;


        @Override
        public AggregatorFactory getAggregatorFactory(InstrumentValueType instrumentValueType) {
            return instrumentValueType == InstrumentValueType.LONG ? LongSumAggregator.getFactory() : DoubleSumAggregator.getFactory();
        }

        @Override
        public MetricData toMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, Map<Labels, Aggregator> aggregatorMap, long startEpochNanos, long epochNanos) {
            List points = Aggregations.getPointList(aggregatorMap, startEpochNanos, epochNanos);
            boolean isMonotonic = descriptor.getType() == InstrumentType.COUNTER || descriptor.getType() == InstrumentType.SUM_OBSERVER;
            return Aggregations.getSumMetricData(resource, instrumentationLibraryInfo, descriptor, points, isMonotonic);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static enum MinMaxSumCount implements Aggregation
    {
        INSTANCE;


        @Override
        public AggregatorFactory getAggregatorFactory(InstrumentValueType instrumentValueType) {
            return instrumentValueType == InstrumentValueType.LONG ? LongMinMaxSumCount.getFactory() : DoubleMinMaxSumCount.getFactory();
        }

        @Override
        public MetricData toMetricData(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, Map<Labels, Aggregator> aggregatorMap, long startEpochNanos, long epochNanos) {
            if (aggregatorMap.isEmpty()) {
                return null;
            }
            List points = Aggregations.getPointList(aggregatorMap, startEpochNanos, epochNanos);
            return MetricData.createDoubleSummary(resource, instrumentationLibraryInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), MetricData.DoubleSummaryData.create(points));
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

