/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.internal.SystemClock;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.SdkMeter;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.metrics.view.AggregationConfiguration;
import io.opentelemetry.sdk.metrics.view.InstrumentSelector;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SdkMeterProvider
implements MeterProvider {
    private static final Logger LOGGER = Logger.getLogger(SdkMeterProvider.class.getName());
    static final String DEFAULT_METER_NAME = "unknown";
    private final ComponentRegistry<SdkMeter> registry;
    private final MetricProducer metricProducer;
    private final MeterProviderSharedState sharedState;

    private SdkMeterProvider(Clock clock, Resource resource) {
        this.sharedState = MeterProviderSharedState.create(clock, resource);
        this.registry = new ComponentRegistry(instrumentationLibraryInfo -> new SdkMeter(this.sharedState, (InstrumentationLibraryInfo)instrumentationLibraryInfo));
        this.metricProducer = new MetricProducerSdk(this.registry);
    }

    public SdkMeter get(String instrumentationName) {
        return this.get(instrumentationName, null);
    }

    public SdkMeter get(String instrumentationName, @Nullable String instrumentationVersion) {
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            LOGGER.fine("Meter requested without instrumentation name.");
            instrumentationName = DEFAULT_METER_NAME;
        }
        return (SdkMeter)this.registry.get(instrumentationName, instrumentationVersion);
    }

    public MetricProducer getMetricProducer() {
        return this.metricProducer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void registerView(InstrumentSelector selector, AggregationConfiguration specification) {
        this.sharedState.getViewRegistry().registerView(selector, specification);
    }

    private static final class MetricProducerSdk
    implements MetricProducer {
        private final ComponentRegistry<SdkMeter> registry;

        private MetricProducerSdk(ComponentRegistry<SdkMeter> registry) {
            this.registry = registry;
        }

        @Override
        public Collection<MetricData> collectAllMetrics() {
            Collection meters = this.registry.getComponents();
            ArrayList<MetricData> result = new ArrayList<MetricData>(meters.size());
            for (SdkMeter meter : meters) {
                result.addAll(meter.collectAll());
            }
            return Collections.unmodifiableCollection(result);
        }
    }

    public static final class Builder {
        private Clock clock = SystemClock.getInstance();
        private Resource resource = Resource.getDefault();

        private Builder() {
        }

        public Builder setClock(@Nonnull Clock clock) {
            Objects.requireNonNull(clock, "clock");
            this.clock = clock;
            return this;
        }

        public Builder setResource(@Nonnull Resource resource) {
            Objects.requireNonNull(resource, "resource");
            this.resource = resource;
            return this;
        }

        public SdkMeterProvider build() {
            return new SdkMeterProvider(this.clock, this.resource);
        }
    }
}

