/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.api.metrics.LongValueRecorder;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrumentBuilder;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.SynchronousInstrumentAccumulator;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class LongValueRecorderSdk
extends AbstractSynchronousInstrument<BoundInstrument>
implements LongValueRecorder {
    private LongValueRecorderSdk(InstrumentDescriptor descriptor, SynchronousInstrumentAccumulator<BoundInstrument> accumulator) {
        super(descriptor, accumulator);
    }

    public void record(long value, Labels labels) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bind(labels);
        boundInstrument.record(value);
        boundInstrument.unbind();
    }

    public void record(long value) {
        this.record(value, Labels.empty());
    }

    static final class Builder
    extends AbstractSynchronousInstrumentBuilder<Builder>
    implements LongValueRecorder.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, InstrumentType.VALUE_RECORDER, InstrumentValueType.LONG, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public LongValueRecorderSdk build() {
            return this.buildInstrument(BoundInstrument::new, (x$0, x$1) -> new LongValueRecorderSdk((InstrumentDescriptor)x$0, (SynchronousInstrumentAccumulator)x$1));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements LongValueRecorder.BoundLongValueRecorder {
        BoundInstrument(Aggregator aggregator) {
            super(aggregator);
        }

        public void record(long value) {
            this.recordLong(value);
        }
    }
}

