/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.view.Aggregation;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class InstrumentProcessor {
    private final InstrumentDescriptor descriptor;
    private final Aggregation aggregation;
    private final Resource resource;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;
    private final Clock clock;
    private final AggregatorFactory aggregatorFactory;
    private Map<Labels, Aggregator> aggregatorMap;
    private long startEpochNanos;
    private final boolean delta;

    static InstrumentProcessor getCumulativeAllLabels(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, Aggregation aggregation) {
        return new InstrumentProcessor(descriptor, aggregation, meterProviderSharedState.getResource(), meterSharedState.getInstrumentationLibraryInfo(), meterProviderSharedState.getClock(), false);
    }

    static InstrumentProcessor getDeltaAllLabels(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, Aggregation aggregation) {
        return new InstrumentProcessor(descriptor, aggregation, meterProviderSharedState.getResource(), meterSharedState.getInstrumentationLibraryInfo(), meterProviderSharedState.getClock(), true);
    }

    private InstrumentProcessor(InstrumentDescriptor descriptor, Aggregation aggregation, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, Clock clock, boolean delta) {
        this.descriptor = descriptor;
        this.aggregation = aggregation;
        this.resource = resource;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
        this.clock = clock;
        this.aggregatorFactory = aggregation.getAggregatorFactory(descriptor.getValueType());
        this.delta = delta;
        this.aggregatorMap = new HashMap<Labels, Aggregator>();
        this.startEpochNanos = clock.now();
    }

    Aggregator getAggregator() {
        return this.aggregatorFactory.getAggregator();
    }

    void batch(Labels labelSet, Aggregator aggregator, boolean mappedAggregator) {
        if (!aggregator.hasRecordings()) {
            return;
        }
        Aggregator currentAggregator = this.aggregatorMap.get(labelSet);
        if (currentAggregator == null) {
            if (!mappedAggregator) {
                this.aggregatorMap.put(labelSet, aggregator);
                return;
            }
            currentAggregator = this.aggregatorFactory.getAggregator();
            this.aggregatorMap.put(labelSet, currentAggregator);
        }
        aggregator.mergeToAndReset(currentAggregator);
    }

    List<MetricData> completeCollectionCycle() {
        long epochNanos = this.clock.now();
        if (this.aggregatorMap.isEmpty()) {
            return Collections.emptyList();
        }
        MetricData metricData = this.aggregation.toMetricData(this.resource, this.instrumentationLibraryInfo, this.descriptor, this.aggregatorMap, this.startEpochNanos, epochNanos);
        if (this.delta) {
            this.startEpochNanos = epochNanos;
            this.aggregatorMap = new HashMap<Labels, Aggregator>();
        }
        return metricData == null ? Collections.emptyList() : Collections.singletonList(metricData);
    }

    boolean generatesDeltas() {
        return this.delta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstrumentProcessor allLabels = (InstrumentProcessor)o;
        if (this.startEpochNanos != allLabels.startEpochNanos) {
            return false;
        }
        if (this.delta != allLabels.delta) {
            return false;
        }
        if (!Objects.equals(this.descriptor, allLabels.descriptor)) {
            return false;
        }
        if (!Objects.equals(this.aggregation, allLabels.aggregation)) {
            return false;
        }
        if (!Objects.equals(this.resource, allLabels.resource)) {
            return false;
        }
        if (!Objects.equals(this.instrumentationLibraryInfo, allLabels.instrumentationLibraryInfo)) {
            return false;
        }
        if (!Objects.equals(this.clock, allLabels.clock)) {
            return false;
        }
        if (!Objects.equals(this.aggregatorFactory, allLabels.aggregatorFactory)) {
            return false;
        }
        return Objects.equals(this.aggregatorMap, allLabels.aggregatorMap);
    }

    public int hashCode() {
        int result = this.descriptor != null ? this.descriptor.hashCode() : 0;
        result = 31 * result + (this.aggregation != null ? this.aggregation.hashCode() : 0);
        result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
        result = 31 * result + (this.instrumentationLibraryInfo != null ? this.instrumentationLibraryInfo.hashCode() : 0);
        result = 31 * result + (this.clock != null ? this.clock.hashCode() : 0);
        result = 31 * result + (this.aggregatorFactory != null ? this.aggregatorFactory.hashCode() : 0);
        result = 31 * result + (this.aggregatorMap != null ? this.aggregatorMap.hashCode() : 0);
        result = 31 * result + (int)(this.startEpochNanos ^ this.startEpochNanos >>> 32);
        result = 31 * result + (this.delta ? 1 : 0);
        return result;
    }
}

