/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Labels;
import io.opentelemetry.api.metrics.DoubleValueRecorder;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrumentBuilder;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.SynchronousInstrumentAccumulator;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class DoubleValueRecorderSdk
extends AbstractSynchronousInstrument<BoundInstrument>
implements DoubleValueRecorder {
    private DoubleValueRecorderSdk(InstrumentDescriptor descriptor, SynchronousInstrumentAccumulator<BoundInstrument> accumulator) {
        super(descriptor, accumulator);
    }

    public void record(double value, Labels labels) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bind(labels);
        boundInstrument.record(value);
        boundInstrument.unbind();
    }

    public void record(double value) {
        this.record(value, Labels.empty());
    }

    static final class Builder
    extends AbstractSynchronousInstrumentBuilder<Builder>
    implements DoubleValueRecorder.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, InstrumentType.VALUE_RECORDER, InstrumentValueType.DOUBLE, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public DoubleValueRecorderSdk build() {
            return this.buildInstrument(BoundInstrument::new, (x$0, x$1) -> new DoubleValueRecorderSdk((InstrumentDescriptor)x$0, (SynchronousInstrumentAccumulator)x$1));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements DoubleValueRecorder.BoundDoubleValueRecorder {
        BoundInstrument(Aggregator aggregator) {
            super(aggregator);
        }

        public void record(double value) {
            this.recordDouble(value);
        }
    }
}

